within AixLib.Systems.ModularAHU.Validation.MeasuredData;
record AHU2_Preheater_StepResponse
  "Step response of the preheater (mixing circuit) with maximal pump frequency"

  parameter Real AC_1000[:,:]=[0,57.33,59.4,16.29,16.02,16.26,21.06,1344.46,
      3.86,0.0,18.23,21.85,0.0,3412; 10,57.27,59.3,16.32,16.04,16.3,21.03,
      1227.63,3.78,0.0,18.29,21.94,0.0,3409; 20,57.21,59.2,16.32,16.07,16.33,
      21.01,1176.43,3.83,0.0,18.36,21.99,0.0,3449; 30,57.13,59.1,16.33,16.09,
      16.37,20.99,1125.01,3.86,0.0,18.38,22.01,10.79,3410; 40,57.07,59.1,
      16.35,16.11,16.39,20.97,1099.63,3.84,0.02,18.44,21.97,23.74,3423; 50,
      57.08,60.0,16.57,16.14,16.42,20.95,1075.78,3.59,0.13,18.5,21.96,30.94,
      3458; 60,55.35,64.9,17.22,16.24,16.45,20.93,1062.9,3.23,0.4,18.92,22.03,
      43.17,3609; 70,24.67,72.8,22.25,17.65,16.47,20.93,1040.48,3.01,1.01,
      20.28,22.34,54.1,3663; 80,27.06,76.0,38.36,22.47,16.51,21.03,1022.21,
      2.95,1.76,23.94,23.05,66.47,3695; 90,42.48,77.1,45.14,25.64,16.54,21.38,
      1027.96,2.95,2.49,30.83,24.66,72.09,3702; 100,58.25,77.7,66.12,42.58,
      16.57,21.61,1006.34,3.1,3.0,39.0,28.08,82.59,3668; 109,68.32,78.1,75.77,
      59.61,16.66,22.45,1012.02,3.25,3.0,46.15,32.37,95.54,3614; 120,71.69,
      78.3,77.41,66.68,16.73,23.05,994.75,3.3,3.0,51.64,36.49,100.0,3605; 130,
      72.75,78.8,78.34,72.11,16.81,23.81,985.9,3.29,3.0,55.62,39.59,100.0,
      3604; 140,73.35,79.9,78.76,72.87,16.96,25.38,1006.04,3.3,3.0,58.75,
      41.96,100.0,3602; 150,74.29,80.8,79.86,73.66,17.07,26.42,1004.42,3.3,
      3.0,61.3,43.85,100.0,3600; 160,75.29,81.4,80.42,74.14,17.14,27.34,
      1002.65,3.27,3.0,63.41,45.72,100.0,3593; 170,76.06,81.7,81.49,75.53,
      17.19,28.03,1001.49,3.29,3.0,65.19,47.25,100.0,3596; 180,76.49,82.0,
      81.82,76.1,17.33,29.96,983.06,3.27,3.0,66.59,48.52,100.0,3593; 190,
      76.85,82.2,81.94,76.29,17.39,30.72,999.91,3.27,3.0,67.74,49.8,100.0,
      3592; 200,77.09,82.3,82.43,76.97,17.46,31.73,994.67,3.31,3.0,68.7,50.8,
      100.0,3590; 210,77.32,82.4,82.62,77.25,17.53,32.84,998.02,3.29,3.0,69.5,
      51.57,100.0,3587; 220,77.42,82.5,82.66,77.32,17.6,33.97,994.95,3.28,3.0,
      70.12,52.31,100.0,3589; 230,77.58,82.5,82.8,77.52,17.67,34.83,987.57,
      3.29,3.0,70.66,52.83,100.0,3586; 240,77.61,82.5,82.86,77.66,17.7,35.89,
      983.53,3.31,3.0,71.11,53.36,100.0,3587; 249,77.65,82.5,82.88,77.69,
      17.77,36.58,982.12,3.28,3.0,71.44,53.73,100.0,3591; 260,77.68,82.5,
      82.88,77.73,17.82,37.25,980.87,3.23,3.0,71.75,53.95,100.0,3582; 270,
      77.71,82.5,82.87,77.78,17.87,38.07,988.45,3.27,3.0,72.01,54.09,100.0,
      3588; 280,77.68,82.4,82.86,77.79,17.93,39.0,987.72,3.26,3.0,72.24,54.3,
      100.0,3586; 290,77.66,82.4,82.86,77.77,17.99,39.89,988.52,3.24,3.0,
      72.42,54.38,100.0,3587; 300,77.68,82.4,82.84,77.75,18.01,40.23,1009.28,
      3.26,3.0,72.58,54.71,100.0,3579; 310,77.64,82.3,82.77,77.75,18.06,41.11,
      992.89,3.29,3.0,72.73,55.12,100.0,3583; 320,77.59,82.2,82.76,77.74,18.1,
      41.63,1004.36,3.24,3.0,72.85,55.56,100.0,3583; 330,77.53,82.2,82.64,
      77.66,18.15,42.36,997.01,3.3,3.0,72.95,55.71,100.0,3582; 340,77.52,82.1,
      82.61,77.63,18.19,43.14,1009.66,3.25,3.0,73.02,55.94,100.0,3580; 350,
      77.48,82.0,82.6,77.61,18.23,43.63,1004.06,3.28,3.0,73.12,56.03,100.0,
      3579; 360,77.44,81.9,82.51,77.55,18.27,44.08,1008.64,3.24,3.0,73.17,
      56.13,100.0,3578; 370,77.32,81.7,82.34,77.5,18.3,44.68,1010.88,3.25,3.0,
      73.23,56.25,100.0,3579; 380,77.26,81.5,82.24,77.41,18.33,45.27,991.85,
      3.27,3.0,73.23,56.33,100.0,3575; 390,77.09,81.2,81.98,77.27,18.37,45.73,
      988.41,3.27,3.0,73.23,56.41,100.0,3577; 400,76.87,80.9,81.76,77.12,18.4,
      46.2,1008.88,3.26,3.0,73.17,56.49,100.0,3580; 410,76.56,80.3,81.4,76.87,
      18.42,46.48,1010.53,3.24,3.0,73.08,56.59,100.0,3579; 420,76.15,79.7,
      81.15,76.72,18.46,46.93,1021.65,3.26,3.0,72.92,56.58,100.0,3579; 430,
      75.65,79.3,80.43,76.19,18.48,47.27,1002.32,3.3,3.0,72.69,56.53,100.0,
      3578; 440,75.21,79.1,79.88,75.6,18.5,47.49,986.36,3.28,3.0,72.46,56.54,
      100.0,3578; 450,74.9,79.1,79.77,75.45,18.53,48.0,1001.92,3.27,3.0,72.24,
      56.5,100.0,3577; 460,74.79,79.2,79.57,74.96,18.55,48.41,980.97,3.28,3.0,
      72.12,56.48,100.0,3577; 470,74.88,79.5,79.65,74.88,18.57,48.58,1011.67,
      3.23,3.0,72.05,56.48,100.0,3576; 480,75.0,79.7,79.8,74.93,18.59,48.87,
      1004.12,3.27,3.0,72.08,56.41,100.0,3574; 490,75.28,80.0,80.18,75.16,
      18.61,49.18,1003.19,3.27,3.0,72.16,56.41,100.0,3577; 500,75.51,80.2,
      80.38,75.36,18.62,49.3,999.04,3.25,3.0,72.28,56.5,100.0,3571; 510,75.77,
      80.4,80.65,75.62,18.65,49.69,999.46,3.25,3.0,72.42,56.77,100.0,3573;
      520,75.94,80.6,80.9,75.9,18.66,49.98,1003.98,3.27,3.0,72.59,57.05,100.0,
      3571; 530,76.11,80.7,81.03,76.06,18.67,50.1,1013.64,3.23,3.0,72.75,
      57.19,100.0,3571; 540,76.23,80.8,81.16,76.23,18.69,50.34,992.85,3.3,3.0,
      72.91,57.36,100.0,3571; 550,76.33,80.9,81.16,76.32,18.7,50.73,998.67,
      3.27,3.0,73.06,57.5,100.0,3576; 560,76.42,80.9,81.34,76.43,18.72,50.83,
      1002.84,3.27,3.0,73.2,57.62,100.0,3572; 570,76.49,81.0,81.41,76.53,
      18.77,51.17,1013.77,3.25,3.0,73.33,57.72,100.0,3571; 580,76.51,80.9,
      81.43,76.55,18.79,51.42,1024.46,3.26,3.0,73.44,57.83,100.0,3569; 590,
      76.49,80.9,81.44,76.58,18.8,51.59,983.26,3.26,3.0,73.52,58.01,100.0,
      3571; 600,76.53,80.9,81.42,76.58,18.81,51.83,979.71,3.24,3.0,73.6,58.19,
      100.0,3566; 610,76.51,80.9,81.38,76.61,18.84,52.13,977.71,3.23,3.0,
      73.66,58.3,100.0,3572; 620,76.51,80.8,81.33,76.58,18.85,52.3,995.57,
      3.25,3.0,73.71,58.38,100.0,3574; 631,76.48,80.8,81.32,76.56,18.86,52.55,
      1001.24,3.26,3.0,73.74,58.47,100.0,3569; 640,76.42,80.8,81.32,76.54,
      18.87,52.67,990.53,3.24,3.0,73.79,58.47,100.0,3571; 650,76.44,80.7,
      81.26,76.53,18.87,52.95,992.03,3.23,3.0,73.81,58.51,100.0,3568; 660,
      76.39,80.6,81.21,76.52,18.88,53.11,1004.77,3.26,3.0,73.83,58.51,100.0,
      3568; 670,76.31,80.5,81.16,76.45,18.91,53.35,971.17,3.24,3.0,73.86,
      58.46,100.0,3568; 681,76.26,80.3,81.04,76.42,18.92,53.48,1003.24,3.25,
      3.0,73.86,58.58,100.0,3570; 690,76.1,80.2,80.9,76.34,18.95,53.73,
      1006.31,3.26,3.0,73.83,58.68,100.0,3570; 700,75.93,79.9,80.67,76.15,
      18.96,53.83,1008.09,3.24,3.0,73.78,58.8,100.0,3568; 710,75.75,79.7,
      80.59,76.09,18.98,54.04,1004.66,3.26,3.0,73.71,58.94,100.0,3567; 720,
      75.55,79.5,80.23,75.79,19.0,54.19,991.67,3.26,3.0,73.63,59.04,100.0,
      3568; 731,75.38,79.4,80.04,75.6,19.02,54.31,993.49,3.28,3.0,73.53,59.04,
      100.0,3571; 740,75.22,79.3,79.92,75.48,19.03,54.38,997.89,3.27,3.0,
      73.44,59.09,100.0,3567; 750,75.13,79.3,79.87,75.29,19.05,54.5,1005.1,
      3.24,3.0,73.39,59.11,100.0,3545; 760,75.13,79.4,79.85,75.23,19.06,54.58,
      1014.11,3.26,3.0,73.35,59.1,100.0,3565; 771,75.12,79.4,79.87,75.22,
      19.08,54.66,1014.13,3.26,3.0,73.33,59.1,100.0,3567; 780,75.21,79.5,
      79.88,75.22,19.1,54.74,989.03,3.25,3.0,73.35,59.06,100.0,3567; 790,
      75.24,79.5,79.96,75.28,19.11,54.81,997.01,3.29,3.0,73.36,59.06,100.0,
      3568; 800,75.29,79.6,80.01,75.34,19.11,54.85,992.82,3.23,3.0,73.41,
      59.09,100.0,3569; 810,75.34,79.7,80.05,75.37,19.11,54.91,1000.7,3.25,
      3.0,73.45,59.23,100.0,3564; 821,75.37,79.7,80.11,75.42,19.13,54.99,
      1004.8,3.25,3.0,73.47,59.38,100.0,3566; 830,75.43,79.7,80.19,75.48,
      19.15,55.05,1009.21,3.25,3.0,73.55,59.34,100.0,3569; 840,75.5,79.7,80.2,
      75.5,19.17,55.13,1003.52,3.24,3.0,73.61,59.39,100.0,3563; 850,75.48,
      79.8,80.22,75.56,19.18,55.18,1001.55,3.25,3.0,73.66,59.48,100.0,3562;
      860,75.53,79.8,80.24,75.61,19.19,55.23,1006.19,3.26,3.0,73.71,59.57,
      100.0,3567; 871,75.51,79.8,80.27,75.61,19.21,55.3,988.79,3.25,3.0,73.75,
      59.66,100.0,3566; 880,75.53,79.8,80.3,75.62,19.22,55.38,1004.52,3.25,
      3.0,73.79,59.82,100.0,3564; 890,75.55,79.8,80.29,75.62,19.23,55.43,
      989.66,3.27,3.0,73.84,59.84,100.0,3567; 900,75.55,79.8,80.3,75.65,19.24,
      55.46,1004.73,3.25,3.0,73.88,59.84,100.0,3561; 911,75.55,79.8,80.29,
      75.65,19.25,55.53,1002.41,3.27,3.0,73.93,59.89,100.0,3566; 920,75.57,
      79.7,80.26,75.65,19.25,55.63,1009.85,3.24,3.0,73.94,59.89,100.0,3567;
      930,75.53,79.7,80.24,75.65,19.26,55.68,996.85,3.26,3.0,73.96,59.98,
      100.0,3566; 940,75.5,79.7,80.22,75.64,19.27,55.76,1019.97,3.25,3.0,
      73.99,60.0,100.0,3565; 950,75.48,79.7,80.19,75.6,19.28,55.85,991.12,
      3.25,3.0,74.0,60.05,100.0,3565; 961,75.48,79.6,80.16,75.56,19.28,55.88,
      995.77,3.27,3.0,74.02,60.08,100.0,3565; 970,75.43,79.5,80.12,75.55,
      19.28,55.97,1003.35,3.25,3.0,74.01,60.16,100.0,3564; 981,75.37,79.4,
      80.03,75.52,19.29,56.04,996.07,3.25,3.0,74.0,60.17,100.0,3567; 990,
      75.31,79.3,79.91,75.42,19.3,56.1,996.27,3.23,3.0,73.97,60.23,100.0,3566;
      1001,75.21,79.2,79.87,75.37,19.31,56.18,1009.28,3.26,3.0,73.96,60.23,
      100.0,3566; 1010,75.07,79.1,79.75,75.26,19.32,56.24,1003.94,3.27,3.0,
      73.93,60.21,100.0,3564; 1020,75.01,79.1,79.65,75.18,19.33,56.29,996.82,
      3.24,3.0,73.89,60.25,100.0,3564; 1030,74.96,79.0,79.59,75.12,19.34,
      56.33,990.12,3.24,3.0,73.84,60.22,100.0,3564; 1040,74.89,79.0,79.51,
      75.04,19.35,56.36,990.7,3.27,3.0,73.81,60.19,100.0,3566; 1051,74.88,
      78.9,79.48,74.99,19.37,56.44,1000.03,3.26,3.0,73.8,60.19,100.0,3565;
      1060,74.84,78.9,79.47,74.96,19.37,56.48,1011.29,3.25,3.0,73.78,60.27,
      100.0,3565; 1071,74.79,78.9,79.45,74.94,19.37,56.5,988.25,3.26,3.0,
      73.76,60.31,100.0,3561; 1080,74.83,78.9,79.45,74.88,19.39,56.55,1004.24,
      3.26,3.0,73.74,60.23,100.0,3565; 1090,74.79,78.9,79.43,74.91,19.4,56.56,
      977.13,3.24,3.0,73.74,60.27,100.0,3565; 1101,74.83,78.9,79.44,74.88,
      19.4,56.57,986.88,3.26,3.0,73.78,60.32,100.0,3568; 1111,74.83,78.9,
      79.44,74.92,19.42,56.58,1001.66,3.25,3.0,73.78,60.32,100.0,3567; 1121,
      74.79,78.9,79.44,74.9,19.43,56.59,985.12,3.26,3.0,73.79,60.41,100.0,
      3565; 1131,74.79,78.9,79.43,74.87,19.44,56.6,995.6,3.25,3.0,73.79,60.46,
      100.0,3564; 1140,74.79,78.9,79.43,74.89,19.45,56.62,1005.72,3.26,3.0,
      73.81,60.5,100.0,3564; 1150,74.8,78.9,79.41,74.89,19.45,56.63,995.42,
      3.24,3.0,73.81,60.54,100.0,3564; 1160,74.8,78.9,79.42,74.88,19.45,56.65,
      1011.68,3.26,3.0,73.84,60.54,100.0,3566; 1171,74.78,78.9,79.4,74.87,
      19.47,56.68,998.61,3.23,3.0,73.84,60.6,100.0,3565; 1181,74.79,78.9,
      79.41,74.87,19.48,56.71,989.38,3.25,3.0,73.85,60.71,100.0,3560; 1191,
      74.8,78.9,79.4,74.88,19.5,56.74,996.56,3.28,3.0,73.86,60.75,100.0,3563;
      1201,74.8,78.9,79.42,74.9,19.52,56.77,1006.02,3.27,3.0,73.89,60.74,
      100.0,3566; 1211,74.78,78.9,79.38,74.87,19.53,56.82,1006.18,3.23,3.0,
      73.9,60.76,100.0,3562; 1221,74.79,78.9,79.37,74.87,19.52,56.84,984.48,
      3.27,3.0,73.9,60.8,100.0,3564; 1230,74.78,78.9,79.36,74.86,19.51,56.89,
      996.81,3.24,3.0,73.93,60.91,100.0,3565; 1241,74.78,78.8,79.34,74.85,
      19.52,56.91,984.58,3.25,3.0,73.93,60.98,100.0,3565; 1251,74.74,78.8,
      79.33,74.83,19.53,56.94,1012.12,3.23,3.0,73.94,60.92,100.0,3563; 1261,
      74.67,78.7,79.32,74.83,19.54,56.95,997.43,3.27,3.0,73.93,60.92,100.0,
      3560; 1271,74.67,78.7,79.23,74.78,19.55,56.99,1004.56,3.26,3.0,73.91,
      60.96,100.0,3560; 1280,74.62,78.6,79.19,74.77,19.54,56.99,1008.93,3.25,
      3.0,73.91,60.97,100.0,3566; 1291,74.55,78.6,79.16,74.71,19.55,57.03,
      1007.59,3.26,3.0,73.9,61.02,100.0,3563; 1301,74.52,78.5,79.08,74.66,
      19.56,57.05,1005.46,3.24,3.0,73.9,61.08,100.0,3565; 1311,74.48,78.5,
      79.06,74.62,19.57,57.07,999.84,3.21,3.0,73.88,61.08,100.0,3563; 1321,
      74.44,78.4,78.98,74.56,19.58,57.09,993.65,3.23,3.0,73.83,61.07,100.0,
      3566; 1331,74.4,78.4,78.95,74.54,19.6,57.1,999.33,3.27,3.0,73.8,61.03,
      100.0,3563; 1341,74.38,78.4,78.91,74.47,19.61,57.11,1012.11,3.25,3.0,
      73.81,61.01,100.0,3563; 1351,74.32,78.4,78.89,74.43,19.63,57.11,997.84,
      3.22,3.0,73.79,60.93,100.0,3562; 1361,74.34,78.3,78.88,74.41,19.64,57.1,
      1004.35,3.23,3.0,73.78,60.91,100.0,3564; 1370,74.3,78.3,78.84,74.41,
      19.65,57.07,998.38,3.28,3.0,73.76,61.03,100.0,3564; 1381,74.29,78.3,
      78.82,74.4,19.65,57.06,1012.94,3.24,3.0,73.75,61.08,100.0,3562; 1391,
      74.28,78.3,78.79,74.38,19.67,57.06,1008.46,3.25,3.0,73.75,61.04,100.0,
      3560; 1401,74.23,78.3,78.78,74.34,19.68,57.06,998.15,3.26,3.0,73.74,
      61.04,100.0,3560; 1411,74.24,78.2,78.77,74.33,19.68,57.06,1027.42,3.26,
      3.0,73.69,61.03,100.0,3563; 1421,74.19,78.2,78.77,74.31,19.71,57.06,
      998.29,3.25,3.0,73.73,60.96,100.0,3563; 1431,74.22,78.2,78.75,74.29,
      19.71,57.06,1006.1,3.24,3.0,73.73,61.03,100.0,3560; 1441,74.21,78.2,
      78.73,74.28,19.71,57.06,991.82,3.22,3.0,73.71,61.1,100.0,3559; 1451,
      74.22,78.2,78.72,74.27,19.71,57.06,1013.63,3.26,3.0,73.71,61.19,100.0,
      3566; 1461,74.17,78.2,78.72,74.27,19.72,57.06,1002.95,3.25,3.0,73.73,
      61.14,100.0,3563; 1471,74.19,78.2,78.68,74.26,19.72,57.04,1003.59,3.25,
      3.0,73.73,61.26,100.0,3561; 1481,74.12,78.2,78.67,74.25,19.72,57.02,
      987.05,3.25,3.0,73.69,61.26,100.0,3562; 1491,74.14,78.1,78.66,74.23,
      19.73,57.0,1015.54,3.25,3.0,73.69,61.26,100.0,3561; 1501,74.1,78.1,
      78.65,74.23,19.73,56.98,993.17,3.24,3.0,73.71,61.29,100.0,3561; 1511,
      74.12,78.1,78.63,74.2,19.75,56.95,1004.03,3.24,3.0,73.71,61.32,100.0,
      3560; 1521,74.11,78.1,78.63,74.2,19.75,56.92,994.44,3.24,3.0,73.68,
      61.26,100.0,3565; 1531,74.09,78.1,78.63,74.19,19.76,56.9,992.84,3.23,
      3.0,73.69,61.24,100.0,3562; 1541,74.1,78.1,78.62,74.17,19.76,56.87,
      1008.9,3.27,3.0,73.71,61.26,100.0,3566; 1551,74.12,78.1,78.63,74.22,
      19.75,56.84,987.18,3.23,3.0,73.71,61.3,100.0,3561; 1561,74.1,78.1,78.62,
      74.21,19.74,56.84,989.07,3.22,3.0,73.71,61.29,100.0,3561; 1571,74.09,
      78.1,78.59,74.19,19.73,56.82,1016.76,3.26,3.0,73.71,61.35,100.0,3565;
      1581,74.05,78.0,78.58,74.15,19.73,56.81,1004.55,3.24,3.0,73.71,61.37,
      100.0,3566; 1591,74.05,78.0,78.57,74.13,19.72,56.8,991.28,3.26,3.0,
      73.71,61.37,100.0,3562; 1601,74.01,78.0,78.52,74.12,19.72,56.79,983.02,
      3.25,3.0,73.68,61.37,100.0,3563; 1611,73.99,77.9,78.48,74.1,19.72,56.78,
      1014.19,3.26,3.0,73.69,61.41,100.0,3565; 1621,73.97,77.9,78.48,74.11,
      19.74,56.77,1014.96,3.25,3.0,73.68,61.52,100.0,3564; 1631,73.94,77.9,
      78.45,74.07,19.77,56.77,995.26,3.25,3.0,73.66,61.57,100.0,3563; 1641,
      73.91,77.9,78.4,74.02,19.78,56.75,981.26,3.25,3.0,73.67,61.59,100.0,
      3564; 1651,73.91,77.8,78.37,73.98,19.79,56.74,1014.01,3.26,3.0,73.67,
      61.54,100.0,3564; 1661,73.89,77.8,78.35,73.99,19.79,56.73,996.22,3.27,
      3.0,73.63,61.53,100.0,3562; 1671,73.85,77.8,78.33,73.98,19.8,56.72,
      1009.02,3.23,3.0,73.63,61.62,100.0,3562; 1681,73.82,77.8,78.32,73.94,
      19.8,56.72,1003.76,3.25,3.0,73.61,61.58,100.0,3564; 1691,73.78,77.8,
      78.3,73.91,19.8,56.7,988.92,3.24,3.0,73.6,61.48,100.0,3565; 1701,73.78,
      77.7,78.27,73.87,19.8,56.7,994.79,3.28,3.0,73.61,61.43,100.0,3562; 1711,
      73.79,77.7,78.24,73.89,19.79,56.67,983.65,3.29,3.0,73.58,61.4,100.0,
      3561; 1721,73.76,77.7,78.23,73.89,19.8,56.64,996.21,3.24,3.0,73.58,
      61.41,100.0,3560; 1731,73.75,77.7,78.2,73.85,19.81,56.62,1005.01,3.22,
      3.0,73.56,61.43,100.0,3563; 1741,73.74,77.7,78.2,73.83,19.82,56.6,
      1023.78,3.27,3.0,73.56,61.46,100.0,3564; 1751,73.68,77.7,78.2,73.83,
      19.84,56.59,973.15,3.24,3.0,73.53,61.45,100.0,3567; 1761,73.73,77.7,
      78.18,73.8,19.85,56.59,1006.55,3.22,3.0,73.55,61.48,100.0,3565; 1771,
      73.69,77.6,78.17,73.79,19.85,56.56,1004.14,3.24,3.0,73.52,61.48,100.0,
      3560; 1781,73.68,77.6,78.16,73.78,19.85,56.55,983.16,3.24,3.0,73.52,
      61.43,100.0,3564; 1791,73.67,77.6,78.14,73.76,19.85,56.53,1002.88,3.25,
      3.0,73.53,61.49,100.0,3560; 1801,73.68,77.6,78.12,73.76,19.88,56.52,
      1002.2,3.25,3.0,73.53,61.51,100.0,3562; 1811,73.68,77.7,78.13,73.77,
      19.89,56.5,1018.61,3.23,3.0,73.53,61.53,100.0,3565; 1821,73.68,77.7,
      78.16,73.76,19.9,56.49,1000.5,3.25,3.0,73.52,61.49,100.0,3563; 1831,
      73.74,77.7,78.19,73.78,19.88,56.47,998.1,3.24,3.0,73.57,61.51,100.0,
      3566; 1841,73.78,77.7,78.21,73.83,19.87,56.47,992.22,3.25,3.0,73.56,
      61.52,100.0,3560; 1851,73.75,77.7,78.24,73.85,19.86,56.46,990.41,3.27,
      3.0,73.6,61.54,100.0,3560; 1861,73.8,77.7,78.24,73.86,19.86,56.45,
      991.98,3.27,3.0,73.61,61.62,100.0,3563; 1871,73.78,77.7,78.24,73.86,
      19.87,56.44,1005.95,3.26,3.0,73.61,61.78,100.0,3562; 1881,73.76,77.7,
      78.24,73.85,19.87,56.42,984.53,3.26,3.0,73.62,61.75,100.0,3562; 1892,
      73.74,77.7,78.21,73.85,19.9,56.42,1019.69,3.24,3.0,73.62,61.75,100.0,
      3563; 1901,73.73,77.7,78.2,73.82,19.91,56.41,987.17,3.21,3.0,73.62,
      61.67,100.0,3562; 1911,73.74,77.7,78.19,73.81,19.93,56.41,1009.06,3.25,
      3.0,73.63,61.75,100.0,3559; 1921,73.71,77.6,78.2,73.81,19.92,56.41,
      1008.84,3.24,3.0,73.62,61.8,100.0,3563; 1931,73.69,77.6,78.15,73.8,
      19.93,56.41,1006.55,3.26,3.0,73.63,61.81,100.0,3563; 1942,73.67,77.6,
      78.12,73.78,19.94,56.4,993.56,3.24,3.0,73.61,61.86,100.0,3562; 1951,
      73.68,77.6,78.1,73.77,19.95,56.4,1019.2,3.25,3.0,73.58,61.8,100.0,3562;
      1961,73.62,77.6,78.07,73.74,19.96,56.4,1001.67,3.26,3.0,73.58,61.76,
      100.0,3559; 1971,73.63,77.6,78.07,73.7,19.96,56.4,988.55,3.25,3.0,73.57,
      61.75,100.0,3559; 1981,73.6,77.5,78.06,73.69,19.96,56.4,1013.13,3.25,
      3.0,73.57,61.75,100.0,3561; 1992,73.58,77.5,78.05,73.7,19.97,56.4,
      986.94,3.24,3.0,73.57,61.68,100.0,3561; 2001,73.6,77.5,78.06,73.68,
      19.99,56.4,1004.08,3.24,3.0,73.58,61.67,100.0,3562; 2011,73.58,77.5,
      78.04,73.68,20.0,56.4,994.02,3.25,3.0,73.56,61.63,100.0,3565; 2021,
      73.56,77.5,78.02,73.66,20.01,56.4,990.06,3.22,3.0,73.56,61.64,100.0,
      3560; 2032,73.58,77.5,78.02,73.66,20.01,56.4,1013.65,3.23,3.0,73.56,
      61.67,100.0,3562; 2041,73.56,77.5,78.01,73.67,20.01,56.41,1021.16,3.23,
      3.0,73.53,61.64,100.0,3562; 2051,73.57,77.5,77.97,73.65,20.01,56.41,
      987.92,3.25,3.0,73.55,61.63,100.0,3563; 2061,73.52,77.4,77.95,73.64,
      20.01,56.42,991.53,3.27,3.0,73.55,61.63,100.0,3562; 2071,73.52,77.4,
      77.94,73.64,20.02,56.43,1025.03,3.25,3.0,73.52,61.73,100.0,3562; 2082,
      73.49,77.5,77.94,73.62,20.04,56.44,1003.32,3.24,3.0,73.52,61.76,100.0,
      3561; 2091,73.51,77.5,77.93,73.57,20.04,56.44,1023.62,3.26,3.0,73.51,
      61.86,100.0,3561; 2102,73.52,77.6,77.98,73.58,20.03,56.44,1006.24,3.26,
      3.0,73.52,61.82,100.0,3566; 2111,73.57,77.7,78.06,73.63,20.03,56.45,
      1003.98,3.24,3.0,73.55,61.75,100.0,3563; 2121,73.68,77.7,78.14,73.69,
      20.05,56.45,991.94,3.26,3.0,73.58,61.73,100.0,3559; 2132,73.74,77.7,
      78.19,73.78,20.06,56.45,973.82,3.22,3.0,73.61,61.8,100.0,3559; 2141,
      73.8,77.7,78.21,73.82,20.07,56.46,991.96,3.23,3.0,73.66,61.81,100.0,
      3561; 2151,73.79,77.7,78.23,73.86,20.08,56.47,1006.98,3.24,3.0,73.67,
      61.83,100.0,3562; 2161,73.79,77.7,78.23,73.87,20.07,56.47,1001.92,3.23,
      3.0,73.71,61.89,100.0,3560; 2172,73.82,77.7,78.23,73.87,20.07,56.48,
      987.34,3.23,3.0,73.73,61.93,100.0,3563; 2181,73.8,77.7,78.23,73.89,
      20.07,56.49,1005.54,3.28,3.0,73.74,61.96,100.0,3563; 2191,73.78,77.7,
      78.22,73.87,20.07,56.49,988.1,3.25,3.0,73.75,62.04,100.0,3564; 2201,
      73.82,77.7,78.21,73.88,20.09,56.5,1010.04,3.25,3.0,73.75,62.09,100.0,
      3564; 2211,73.78,77.7,78.21,73.9,20.1,56.5,982.66,3.23,3.0,73.75,62.16,
      95.83,3562; 2222,73.79,77.7,78.2,73.86,20.1,56.51,1016.86,3.21,3.0,
      73.75,62.14,87.19,3570; 2231,73.62,77.7,78.2,73.84,20.1,56.51,1006.2,
      3.11,2.98,73.75,62.11,70.22,3631; 2242,73.39,77.7,77.93,73.63,20.12,
      56.51,996.38,2.97,2.35,73.67,62.06,60.58,3647; 2251,72.94,77.7,77.26,
      73.38,20.13,56.51,995.74,3.01,1.61,73.51,62.03,51.22,3639; 2261,72.48,
      77.6,75.75,72.62,20.14,56.52,984.87,3.05,0.81,73.09,61.95,42.45,3605;
      2271,72.11,77.5,74.72,72.11,20.13,56.51,1003.75,3.38,0.34,72.42,61.75,
      31.08,3514; 2281,71.92,77.4,71.67,70.07,20.1,56.48,980.59,3.75,0.09,
      71.5,61.37,22.45,3427; 2292,71.89,77.3,69.21,68.02,20.09,56.45,1007.87,
      3.86,0.01,70.36,60.87,7.48,3400; 2301,71.87,77.2,68.43,67.3,20.07,56.41,
      1005.02,3.93,0.0,69.08,60.32,2.16,3430; 2312,71.87,77.1,65.29,64.25,
      20.05,56.3,999.01,4.07,0.0,67.73,59.64,0.0,3414; 2321,71.81,77.0,63.56,
      62.56,20.05,56.16,994.5,4.01,0.0,66.33,58.94,0.0,3387; 2332,71.72,76.8,
      61.96,61.0,20.05,56.0,993.78,4.03,0.0,64.89,58.21,0.0,3436; 2342,71.56,
      76.6,59.92,59.02,20.04,55.86,1026.52,4.08,0.0,63.49,57.47,0.0,3398;
      2351,71.41,76.3,58.08,57.21,20.01,55.69,1006.57,3.62,0.0,62.12,56.75,
      0.0,3403; 2362,71.28,76.1,56.14,55.29,20.0,55.61,1025.18,3.56,0.0,60.77,
      56.06,0.0,3427; 2371,71.14,75.9,54.39,53.58,19.97,55.27,1007.3,4.0,0.0,
      59.46,55.34,0.0,3419; 2382,71.01,75.7,53.12,52.34,19.95,55.0,1018.08,
      4.08,0.0,58.19,54.72,0.0,3403; 2392,70.87,75.5,51.45,50.68,19.93,54.78,
      1024.14,4.08,0.0,57.0,54.07,0.0,3413; 2401,70.75,75.3,50.71,49.97,19.91,
      54.49,1001.53,4.08,0.0,55.83,53.43,0.0,3497; 2412,70.6,75.0,49.22,48.5,
      19.88,53.98,996.31,4.08,0.0,54.7,52.85,0.0,3404; 2422,70.5,74.9,47.57,
      46.88,19.86,53.85,987.43,4.08,0.0,53.6,52.25,0.0,3413; 2432,70.37,74.6,
      47.18,46.49,19.83,53.39,1010.65,4.08,0.0,52.55,51.65,0.0,3452; 2442,
      70.27,74.4,45.53,44.86,19.8,52.97,979.7,4.08,0.0,51.53,51.1,0.0,3421;
      2452,70.14,74.2,44.62,43.96,19.78,52.65,1000.72,4.08,0.0,50.55,50.59,
      0.0,3415; 2462,69.94,74.0,43.76,43.12,19.75,52.27,993.58,4.08,0.0,49.64,
      50.08,0.0,3419; 2472,69.79,73.8,42.45,41.81,19.72,51.71,1015.76,4.08,
      0.0,48.75,49.57,0.0,3420; 2482,69.64,73.6,41.66,41.04,19.69,51.18,
      1002.98,4.08,0.0,47.87,49.06,0.0,3402; 2491,69.53,73.4,40.6,39.99,19.66,
      50.7,988.18,4.08,0.0,47.05,48.62,0.0,3458; 2502,69.39,73.2,40.13,39.53,
      19.64,50.39,989.81,4.08,0.0,46.25,48.14,0.0,3434; 2512,69.28,73.0,38.96,
      38.38,19.63,49.58,996.12,4.08,0.0,45.48,47.6,0.0,3420; 2522,69.15,72.8,
      38.31,37.74,19.6,49.14,1009.87,4.08,0.0,44.73,47.12,0.0,3439; 2532,
      69.03,72.6,38.03,37.47,19.58,48.57,1019.02,4.08,0.0,44.01,46.67,0.0,
      3447; 2541,68.86,72.4,36.79,36.24,19.56,48.23,998.97,4.08,0.0,43.32,
      46.23,0.0,3422; 2552,68.7,72.2,35.87,35.34,19.52,47.23,1012.31,4.08,0.0,
      42.64,45.74,0.0,3442; 2562,68.57,72.0,35.63,35.11,19.5,46.99,980.4,4.08,
      0.0,41.98,45.27,0.0,3479; 2572,68.46,71.8,34.7,34.19,19.47,46.3,1014.33,
      4.08,0.0,41.35,44.88,0.0,3414; 2582,68.29,71.6,34.18,33.67,19.44,45.5,
      1014.7,4.08,0.0,40.74,44.43,0.0,3423; 2592,68.14,71.4,33.56,33.06,19.42,
      45.04,1016.57,4.08,0.0,40.17,43.91,0.0,3394; 2602,68.01,71.2,32.93,
      32.44,19.41,44.71,1012.11,4.08,0.0,39.6,43.56,0.0,3439; 2612,67.89,71.0,
      32.49,32.02,19.36,43.95,1010.48,4.08,0.0,39.05,43.19,0.0,3460; 2622,
      67.78,70.8,31.88,31.41,19.34,43.25,1020.75,4.08,0.0,38.52,42.81,0.0,
      3441; 2631,67.67,70.6,31.33,30.87,19.33,42.94,992.38,4.08,0.0,38.02,
      42.37,0.0,3435; 2642,67.57,70.4,30.94,30.47,19.32,42.37,1006.95,4.08,
      0.0,37.53,41.98,0.0,3395; 2652,67.46,70.3,30.44,29.98,19.3,41.91,990.59,
      4.08,0.0,37.04,41.54,0.0,3439; 2662,67.35,70.1,30.05,29.61,19.28,41.52,
      998.64,4.08,0.0,36.58,41.13,0.0,3422; 2672,67.22,69.9,29.66,29.22,19.25,
      40.78,1005.39,4.08,0.0,36.14,40.82,0.0,3460; 2682,67.11,69.7,29.33,
      28.88,19.24,40.38,992.87,4.08,0.0,35.7,40.51,0.0,3421; 2692,66.99,69.6,
      28.99,28.55,19.22,40.02,1017.69,4.08,0.0,35.28,40.27,0.0,3436; 2702,
      66.86,69.3,28.56,28.11,19.2,39.5,1011.21,4.08,0.0,34.88,40.0,0.0,3414;
      2712,66.75,69.2,28.16,27.72,19.18,39.08,1014.68,4.08,0.0,34.49,39.73,
      0.0,3474; 2722,66.62,69.0,27.73,27.32,19.17,38.68,1001.63,4.08,0.0,34.1,
      39.46,0.0,3415; 2732,66.52,68.8,27.36,26.96,19.15,38.4,1028.44,4.03,0.0,
      33.74,39.1,0.0,3448; 2742,66.41,68.6,27.09,26.71,19.14,37.96,974.65,
      3.91,0.0,33.4,38.82,0.0,3416; 2752,66.29,68.5,26.72,26.35,19.12,37.43,
      997.62,3.87,0.0,33.03,38.58,0.0,3443; 2762,66.17,68.3,26.56,26.18,19.1,
      37.04,1005.82,3.93,0.0,32.71,38.32,0.0,3414; 2772,66.07,68.1,26.24,
      25.86,19.08,36.64,1005.73,3.9,0.0,32.37,38.1,0.0,3468; 2782,65.96,68.0,
      25.88,25.5,19.07,36.47,1005.84,3.93,0.0,32.05,37.77,0.0,3423; 2792,
      65.85,67.8,25.79,25.42,19.05,36.09,1002.38,3.93,0.0,31.77,37.47,0.0,
      3402; 2802,65.74,67.6,25.4,25.05,19.04,35.69,1002.73,3.96,0.0,31.48,
      37.14,0.0,3407; 2812,65.62,67.4,25.09,24.73,19.03,35.35,986.38,3.87,0.0,
      31.14,36.84,0.0,3411; 2822,65.53,67.2,25.0,24.65,19.02,34.93,1009.13,
      3.88,0.0,30.91,36.64,0.0,3442; 2832,65.43,67.1,24.71,24.35,19.01,34.73,
      1006.99,3.87,0.0,30.61,36.42,0.0,3412; 2842,65.34,66.9,24.53,24.16,19.0,
      34.33,1010.79,3.32,0.0,30.37,36.19,0.0,3441; 2852,65.23,66.7,24.27,
      23.91,19.0,34.02,1005.03,3.46,0.0,30.12,35.97,0.0,3447; 2862,65.15,66.6,
      24.06,23.72,18.99,33.73,1015.56,2.21,0.0,29.87,35.78,0.0,3406; 2872,
      65.02,66.4,23.89,23.57,18.98,33.43,993.74,1.69,0.0,29.62,35.5,0.0,3447;
      2882,64.93,66.3,23.72,23.4,18.96,33.19,993.89,3.26,0.0,29.4,35.24,0.0,
      3401; 2892,64.84,66.1,23.53,23.2,18.94,32.97,1025.91,2.39,0.0,29.18,
      35.0,0.0,3448; 2902,64.72,66.0,23.37,23.05,18.93,32.82,998.98,3.86,0.0,
      28.96,34.69,0.0,3455; 2912,64.64,65.8,23.16,22.82,18.91,32.46,1015.26,
      3.94,0.0,28.73,34.37,0.0,3437; 2922,64.53,65.6,23.01,22.69,18.9,32.12,
      1003.72,3.95,0.0,28.52,34.14,0.0,3411; 2932,64.44,65.5,22.88,22.54,
      18.89,31.82,1002.41,3.86,0.0,28.32,33.93,0.0,3409; 2942,64.33,65.3,
      22.74,22.42,18.88,31.59,1008.4,3.92,0.0,28.14,33.82,0.0,3416; 2952,
      64.25,65.2,22.59,22.26,18.87,31.36,1011.01,3.88,0.0,27.93,33.68,0.0,
      3447; 2962,64.15,65.0,22.44,22.11,18.87,31.26,991.36,3.9,0.0,27.75,
      33.55,0.0,3443; 2972,64.08,64.9,22.31,22.01,18.86,30.92,1006.45,3.88,
      0.0,27.58,33.42,0.0,3440; 2982,63.98,64.7,22.17,21.85,18.85,30.6,
      1001.82,3.94,0.0,27.39,33.23,0.0,3466; 2992,63.87,64.5,22.03,21.71,
      18.84,30.51,998.95,3.86,0.0,27.2,33.09,0.0,3417; 3002,63.78,64.4,21.91,
      21.62,18.82,30.18,988.83,3.84,0.0,27.03,32.93,0.0,3398; 3012,63.69,64.2,
      21.79,21.5,18.82,30.07,996.66,3.92,0.0,26.87,32.78,0.0,3428; 3022,63.6,
      64.1,21.71,21.39,18.81,29.89,988.6,3.94,0.0,26.71,32.65,0.0,3410; 3032,
      63.51,63.9,21.61,21.29,18.8,29.58,1009.06,3.93,0.0,26.56,32.46,0.0,3434;
      3042,63.42,63.8,21.47,21.15,18.8,29.39,1003.34,3.79,0.0,26.42,32.32,0.0,
      3437; 3052,63.33,63.6,21.36,21.07,18.79,29.22,977.05,3.92,0.0,26.25,
      32.21,0.0,3435; 3063,63.25,63.5,21.33,21.01,18.78,29.08,1022.99,3.86,
      0.0,26.1,32.04,0.0,3433; 3072,63.16,63.3,21.19,20.89,18.77,28.88,1007.7,
      3.84,0.0,25.96,31.86,0.0,3422; 3082,63.07,63.2,21.1,20.82,18.77,28.68,
      999.67,3.95,0.0,25.82,31.7,0.0,3443; 3092,62.98,63.1,21.02,20.7,18.76,
      28.52,987.09,3.95,0.0,25.68,31.58,0.0,3413; 3102,62.89,62.9,20.93,20.65,
      18.76,28.33,1002.9,3.92,0.0,25.55,31.47,0.0,3438; 3113,62.82,62.8,20.83,
      20.54,18.76,28.17,1003.39,3.84,0.0,25.42,31.28,0.0,3421; 3122,62.71,
      62.6,20.79,20.51,18.75,28.04,1008.73,3.88,0.0,25.31,31.14,0.0,3412;
      3132,62.65,62.5,20.67,20.38,18.74,27.85,996.62,3.94,0.0,25.19,30.98,0.0,
      3411; 3142,62.55,62.3,20.63,20.31,18.73,27.79,985.44,3.96,0.0,25.06,
      30.85,0.0,3420; 3153,62.48,62.2,20.54,20.26,18.73,27.54,1002.18,3.9,0.0,
      24.94,30.71,0.0,3441; 3163,62.4,62.1,20.5,20.19,18.72,27.49,990.61,3.91,
      0.0,24.85,30.57,0.0,3474; 3172,62.3,61.9,20.39,20.12,18.71,27.33,
      1014.37,3.96,0.0,24.74,30.44,0.0,3404; 3182,62.23,61.8,20.37,20.1,18.7,
      27.14,982.24,3.9,0.0,24.6,30.3,0.0,3436; 3192,62.15,61.7,20.3,19.99,
      18.69,27.04,1004.31,3.91,0.0,24.5,30.21,0.0,3451; 3203,62.06,61.5,20.23,
      19.94,18.69,26.94,1005.08,3.78,0.0,24.39,30.05,0.0,3455; 3212,61.99,
      61.4,20.2,19.87,18.69,26.81,1010.94,3.87,0.0,24.31,29.92,0.0,3414; 3223,
      61.9,61.3,20.11,19.83,18.69,26.63,1015.65,3.83,0.0,24.21,29.77,0.0,3417;
      3232,61.83,61.1,20.08,19.79,18.68,26.53,1002.76,3.96,0.0,24.11,29.57,
      0.0,3418; 3242,61.73,61.0,20.02,19.72,18.67,26.42,1004.55,3.92,0.0,
      24.03,29.35,0.0,3437; 3253,61.66,60.9,19.97,19.7,18.67,26.27,988.82,
      3.79,0.0,23.93,29.24,0.0,3414; 3262,61.56,60.7,19.92,19.62,18.67,26.23,
      988.31,3.92,0.0,23.84,29.17,0.0,3467; 3273,61.5,60.6,19.85,19.58,18.67,
      26.06,988.98,3.93,0.0,23.76,29.07,0.0,3444; 3283,61.42,60.5,19.81,19.54,
      18.66,25.98,1016.13,3.79,0.0,23.66,28.94,0.0,3409; 3293,61.38,60.3,19.8,
      19.49,18.65,25.88,980.43,3.98,0.0,23.6,28.85,0.0,3441; 3303,61.28,60.2,
      19.76,19.45,18.65,25.76,1005.24,3.84,0.0,23.5,28.73,0.0,3419; 3313,
      61.19,60.1,19.7,19.42,18.65,25.66,1018.68,3.87,0.0,23.42,28.63,0.0,3426;
      3323,61.13,59.9,19.67,19.38,18.64,25.56,1001.22,3.9,0.0,23.33,28.56,0.0,
      3408; 3333,61.06,59.8,19.64,19.32,18.64,25.5,1006.94,3.92,0.0,23.25,
      28.47,0.0,3456; 3343,60.99,59.7,19.59,19.29,18.64,25.4,998.57,3.74,0.0,
      23.17,28.35,0.0,3406; 3353,60.92,59.5,19.55,19.26,18.63,25.27,1015.74,
      3.83,0.0,23.12,28.26,0.0,3412; 3363,60.83,59.4,19.53,19.23,18.62,25.19,
      1003.08,3.96,0.0,23.02,28.14,0.0,3421; 3373,60.75,59.3,19.51,19.18,
      18.62,25.13,1019.21,3.86,0.0,22.95,28.07,0.0,3422; 3383,60.69,59.2,
      19.47,19.16,18.62,25.05,1001.14,3.9,0.0,22.87,28.03,0.0,3439; 3393,
      60.62,59.0,19.41,19.14,18.61,24.94,998.05,3.84,0.0,22.81,27.97,0.0,3448;
      3403,60.53,58.9,19.39,19.11,18.6,24.84,996.4,3.85,0.0,22.75,27.87,0.0,
      3418; 3413,60.47,58.8,19.38,19.08,18.59,24.77,1005.27,4.04,0.0,22.68,
      27.76,0.0,3432; 3423,60.4,58.7,19.35,19.05,18.59,24.67,996.51,3.86,0.0,
      22.61,27.67,0.0,3428; 3433,60.34,58.5,19.29,19.02,18.59,24.63,1017.55,
      3.84,0.0,22.54,27.6,0.0,3447; 3443,60.28,58.4,19.28,19.0,18.58,24.52,
      1004.95,3.83,0.0,22.5,27.53,0.0,3432; 3453,60.2,58.3,19.26,18.97,18.58,
      24.46,1014.95,3.88,0.0,22.42,27.41,0.0,3421; 3463,60.14,58.2,19.25,
      18.94,18.58,24.39,998.72,3.95,0.0,22.37,27.32,0.0,3439; 3473,60.08,58.0,
      19.23,18.92,18.58,24.35,1002.03,3.9,0.0,22.32,27.21,0.0,3405; 3483,
      60.01,57.9,19.2,18.89,18.58,24.25,1011.41,3.92,0.0,22.23,27.02,0.0,3420;
      3493,59.93,57.8,19.15,18.88,18.57,24.2,983.38,4.03,0.0,22.2,26.84,0.0,
      3409; 3503,59.87,57.7,19.14,18.86,18.57,24.16,1012.84,3.83,0.0,22.14,
      26.72,0.0,3465; 3513,59.77,57.6,19.12,18.85,18.57,24.07,982.1,3.78,0.0,
      22.09,26.63,0.0,3419; 3523,59.73,57.4,19.12,18.82,18.56,23.99,975.26,
      3.73,0.0,22.05,26.55,0.0,3404; 3533,59.66,57.3,19.11,18.8,18.56,23.96,
      999.35,3.76,0.0,21.98,26.51,0.0,3451; 3543,59.6,57.2,19.1,18.79,18.56,
      23.86,1001.93,3.95,0.0,21.92,26.48,0.0,3472; 3553,59.53,57.1,19.05,
      18.75,18.55,23.82,1004.12,3.78,0.0,21.89,26.43,0.0,3423; 3563,59.48,
      57.0,19.03,18.75,18.55,23.8,1010.03,3.87,0.0,21.83,26.36,0.0,3435; 3573,
      59.42,56.9,19.01,18.74,18.56,23.71,1002.69,3.74,0.0,21.76,26.29,0.0,
      3419; 3583,59.36,56.8,18.98,18.73,18.56,23.66,1001.72,4.0,0.0,21.74,
      26.24,0.0,3469; 3593,59.29,56.6,18.97,18.71,18.56,23.62,988.04,3.73,0.0,
      21.67,26.15,0.0,3430; 3603,59.25,56.5,18.97,18.7,18.57,23.56,994.33,
      3.91,0.0,21.64,26.1,0.0,3407; 3613,59.18,56.4,18.94,18.66,18.57,23.5,
      1000.84,3.89,0.0,21.6,26.08,0.0,3409; 3623,59.1,56.3,18.93,18.65,18.57,
      23.46,1020.75,3.83,0.0,21.55,26.03,0.0,3428; 3633,59.07,56.2,18.92,
      18.63,18.58,23.39,1015.56,3.88,0.0,21.51,25.98,0.0,3402; 3643,58.98,
      56.1,18.9,18.63,18.58,23.34,994.95,3.8,0.0,21.46,25.91,0.0,3442; 3653,
      58.92,56.0,18.88,18.62,18.57,23.29,1012.76,3.89,0.0,21.43,25.79,0.0,
      3405; 3663,58.85,55.8,18.87,18.61,18.57,23.23,993.06,3.79,0.0,21.39,
      25.73,0.0,3451; 3673,58.76,55.7,18.86,18.61,18.56,23.17,999.19,3.9,0.0,
      21.35,25.68,0.0,3474; 3683,58.72,55.6,18.85,18.6,18.56,23.12,986.58,
      3.84,0.0,21.3,25.61,0.0,3464; 3694,58.65,55.5,18.84,18.58,18.55,23.08,
      991.81,3.86,0.0,21.27,25.49,0.0,3393; 3703,58.59,55.4,18.84,18.59,18.55,
      23.05,1001.49,3.94,0.0,21.22,25.41,0.0,3396; 3713,58.53,55.3,18.84,
      18.57,18.55,22.99,1006.1,3.85,0.0,21.18,25.32,0.0,3416; 3723,58.47,55.2,
      18.84,18.57,18.55,22.95,1000.23,3.96,0.0,21.15,25.3,0.0,3398; 3733,
      58.42,55.1,18.83,18.55,18.55,22.9,1019.78,3.82,0.0,21.12,25.22,0.0,3418;
      3743,58.33,55.0,18.82,18.55,18.55,22.87,1001.88,3.94,0.0,21.07,25.18,
      0.0,3420; 3753,58.28,54.9,18.81,18.53,18.55,22.83,993.72,3.91,0.0,21.03,
      25.1,0.0,3447; 3763,58.21,54.8,18.8,18.52,18.54,22.79,1000.84,3.93,0.0,
      21.01,24.93,0.0,3414; 3773,58.14,54.6,18.78,18.5,18.54,22.74,991.13,
      4.01,0.0,20.97,24.83,0.0,3427; 3783,58.08,54.5,18.77,18.49,18.53,22.69,
      1013.72,3.92,0.0,20.95,24.78,0.0,3417; 3793,58.01,54.4,18.75,18.48,
      18.53,22.65,978.28,3.71,0.0,20.92,24.72,0.0,3392; 3803,57.97,54.3,18.74,
      18.47,18.53,22.62,985.53,3.88,0.0,20.87,24.64,0.0,3414; 3813,57.89,54.2,
      18.73,18.47,18.53,22.59,1003.05,3.97,0.0,20.85,24.6,0.0,3404; 3823,
      57.85,54.1,18.72,18.47,18.54,22.56,1010.68,3.92,0.0,20.81,24.57,0.0,
      3392; 3833,57.77,54.0,18.72,18.46,18.54,22.52,1005.42,3.94,0.0,20.79,
      24.51,0.0,3393; 3843,57.73,53.9,18.71,18.45,18.54,22.49,1005.03,3.89,
      0.0,20.76,24.5,0.0,3447; 3853,57.67,53.8,18.71,18.45,18.54,22.45,
      1020.22,3.93,0.0,20.72,24.48,0.0,3432; 3863,57.62,53.7,18.7,18.44,18.54,
      22.42,987.18,3.9,0.0,20.69,24.46,0.0,3430; 3873,57.55,53.6,18.7,18.44,
      18.54,22.4,988.31,3.93,0.0,20.66,24.41,0.0,3445; 3883,57.5,53.5,18.7,
      18.44,18.54,22.35,1023.42,3.76,0.0,20.64,24.39,0.0,3463; 3893,57.44,
      53.4,18.7,18.43,18.54,22.32,1007.19,3.76,0.0,20.61,24.3,0.0,3436; 3903,
      57.38,53.3,18.7,18.43,18.54,22.29,1008.27,3.83,0.0,20.58,24.29,0.0,3406;
      3913,57.33,53.2,18.7,18.42,18.54,22.26,992.43,3.79,0.0,20.57,24.27,0.0,
      3404; 3923,57.24,53.1,18.69,18.4,18.55,22.23,1001.49,3.96,0.0,20.52,
      24.2,0.0,3409; 3933,57.18,53.0,18.68,18.4,18.55,22.21,984.94,3.88,0.0,
      20.49,24.16,0.0,3395; 3943,57.13,52.9,18.68,18.38,18.55,22.18,996.0,
      3.85,0.0,20.47,24.09,0.0,3391; 3953,57.1,52.8,18.67,18.38,18.54,22.14,
      988.96,3.91,0.0,20.44,24.02,0.0,3426; 3963,57.01,52.7,18.67,18.37,18.54,
      22.12,1014.41,3.91,0.0,20.42,23.92,0.0,3397; 3973,56.96,52.6,18.65,
      18.36,18.54,22.1,989.08,3.9,0.0,20.41,23.86,0.0,3392; 3983,56.89,52.5,
      18.65,18.36,18.54,22.07,983.76,3.88,0.0,20.37,23.87,0.0,3423; 3993,
      56.85,52.4,18.63,18.35,18.54,22.04,999.42,3.95,0.0,20.35,23.8,0.0,3477;
      4003,56.8,52.3,18.64,18.34,18.54,22.01,983.52,3.94,0.0,20.33,23.79,0.0,
      3416; 4013,56.73,52.2,18.64,18.35,18.54,21.98,996.54,3.84,0.0,20.32,
      23.74,0.0,3415; 4023,56.67,52.1,18.62,18.34,18.54,21.96,1004.62,3.95,
      0.0,20.28,23.66,0.0,3409; 4033,56.62,52.0,18.61,18.34,18.54,21.95,
      1006.76,3.79,0.0,20.26,23.63,0.0,3417; 4043,56.56,52.0,18.61,18.34,
      18.54,21.91,1010.38,3.81,0.0,20.25,23.58,0.0,3418; 4053,56.51,51.8,
      18.62,18.34,18.52,21.89,1006.81,3.81,0.0,20.21,23.58,0.0,3403; 4063,
      56.44,51.8,18.6,18.34,18.52,21.87,999.18,3.94,0.0,20.21,23.57,0.0,3398;
      4073,56.4,51.7,18.6,18.34,18.52,21.84,1006.73,3.87,0.0,20.17,23.47,0.0,
      3428; 4083,56.33,51.6,18.6,18.34,18.53,21.82,998.94,3.82,0.0,20.16,
      23.43,0.0,3400; 4093,56.28,51.5,18.59,18.33,18.52,21.8,985.99,3.98,0.0,
      20.14,23.38,0.0,3414; 4103,56.23,51.4,18.6,18.34,18.52,21.79,1000.57,
      3.91,0.0,20.1,23.36,0.0,3404; 4113,56.18,51.3,18.59,18.33,18.53,21.76,
      1007.32,3.94,0.0,20.09,23.3,0.0,3441; 4123,56.13,51.2,18.59,18.32,18.53,
      21.74,1007.07,4.02,0.0,20.08,23.21,0.0,3437; 4133,56.07,51.1,18.59,
      18.34,18.54,21.73,1001.47,3.79,0.0,20.07,23.17,0.0,3409; 4143,56.02,
      51.0,18.58,18.33,18.54,21.69,997.96,3.82,0.0,20.04,23.14,0.0,3399; 4153,
      55.96,50.9,18.58,18.34,18.54,21.66,1010.13,3.8,0.0,20.01,23.07,0.0,3452;
      4163,55.91,50.8,18.57,18.33,18.54,21.65,993.63,3.9,0.0,20.0,23.0,0.0,
      3397; 4173,55.86,50.7,18.58,18.32,18.53,21.62,1012.72,3.85,0.0,20.0,
      23.0,0.0,3416; 4183,55.8,50.7,18.57,18.32,18.53,21.6,997.67,4.0,0.0,
      19.98,23.02,0.0,3396; 4193,55.75,50.6,18.58,18.32,18.53,21.58,986.49,
      3.81,0.0,19.95,22.96,0.0,3444; 4203,55.68,50.5,18.57,18.32,18.53,21.56,
      998.47,3.91,0.0,19.93,22.96,0.0,3424; 4214,55.63,50.4,18.57,18.31,18.53,
      21.54,996.95,3.81,0.0,19.92,22.94,0.0,3432; 4223,55.58,50.3,18.57,18.31,
      18.53,21.52,998.1,3.83,0.0,19.89,22.91,0.0,3409; 4233,55.52,50.2,18.57,
      18.31,18.53,21.51,1004.36,3.72,0.0,19.87,22.87,0.0,3400; 4243,55.47,
      50.1,18.57,18.31,18.53,21.49,996.51,3.9,0.0,19.85,22.84,0.0,3400; 4254,
      55.42,50.0,18.56,18.31,18.53,21.47,993.76,3.93,0.0,19.83,22.8,0.0,3394;
      4264,55.36,49.9,18.56,18.31,18.53,21.45,1004.12,3.85,0.0,19.83,22.76,
      0.0,3423; 4273,55.3,49.9,18.57,18.3,18.52,21.43,998.21,3.83,0.0,19.82,
      22.7,0.0,3415; 4283,55.26,49.8,18.57,18.3,18.52,21.42,999.91,4.01,0.0,
      19.79,22.65,0.0,3448; 4293,55.2,49.7,18.56,18.3,18.53,21.39,1011.01,
      3.88,0.0,19.78,22.53,0.0,3414; 4304,55.15,49.6,18.57,18.3,18.53,21.38,
      995.19,3.9,0.0,19.76,22.51,0.0,3430; 4313,55.1,49.5,18.56,18.3,18.53,
      21.35,992.63,4.0,0.0,19.74,22.5,0.0,3435; 4324,55.03,49.5,18.57,18.3,
      18.53,21.34,987.64,3.88,0.0,19.73,22.45,0.0,3408; 4333,54.98,49.4,18.56,
      18.3,18.53,21.33,992.13,3.91,0.0,19.73,22.44,0.0,3414; 4343,54.93,49.3,
      18.57,18.3,18.53,21.31,1003.2,3.8,0.0,19.72,22.4,0.0,3422; 4354,54.86,
      49.2,18.56,18.29,18.53,21.29,999.34,3.75,0.0,19.69,22.37,0.0,3401; 4363,
      54.82,49.1,18.56,18.29,18.53,21.28,978.25,3.89,0.0,19.69,22.33,0.0,3408;
      4373,54.77,49.0,18.56,18.29,18.52,21.27,997.43,3.84,0.0,19.67,22.32,0.0,
      3408; 4383,54.7,49.0,18.56,18.29,18.52,21.25,993.89,3.87,0.0,19.67,
      22.29,0.0,3414; 4394,54.66,48.9,18.56,18.28,18.53,21.25,1008.71,3.83,
      0.0,19.65,22.28,0.0,3436; 4403,54.6,48.8,18.56,18.29,18.52,21.23,992.9,
      3.87,0.0,19.63,22.21,0.0,3448; 4414,54.55,48.7,18.57,18.29,18.52,21.21,
      1010.75,3.93,0.0,19.62,22.16,0.0,3468; 4424,54.48,48.6,18.56,18.29,
      18.52,21.2,995.69,3.77,0.0,19.62,22.11,0.0,3419; 4433,54.44,48.6,18.57,
      18.28,18.52,21.18,1009.1,3.84,0.0,19.61,22.1,0.0,3421];
  // Measured data for step response with a volume flow of 1000 m^3/h in the air canal

  parameter Real AC_2000[:,:]=[0,56.68,59.8,13.15,12.92,13.35,15.41,2040.69,
      3.88,0.0,13.63,14.89,0.0,3414; 10,56.62,59.7,13.17,12.93,13.37,15.42,
      2031.57,3.85,0.0,13.63,14.9,0.0,3424; 20,56.56,59.5,13.18,12.93,13.38,
      15.43,2064.83,3.87,0.0,13.63,14.89,0.0,3396; 30,56.52,59.4,13.18,12.94,
      13.39,15.43,2013.63,3.8,0.0,13.63,14.91,0.0,3442; 40,56.45,59.3,13.2,
      12.97,13.41,15.44,2010.62,3.76,0.0,13.64,14.87,0.0,3425; 50,56.37,59.1,
      13.22,12.97,13.42,15.44,2010.67,3.77,0.0,13.65,14.9,0.0,3455; 60,56.33,
      59.0,13.23,12.99,13.42,15.45,2025.48,3.85,0.0,13.67,14.91,0.0,3445; 70,
      56.28,58.8,13.24,12.99,13.44,15.45,1996.52,3.82,0.0,13.65,14.91,4.6,
      3456; 80,56.2,58.7,13.26,13.01,13.44,15.45,2015.24,3.77,0.0,13.67,14.89,
      15.68,3409; 90,56.11,58.7,13.27,13.02,13.46,15.45,2006.69,3.78,0.03,
      13.67,14.86,23.31,3430; 100,54.96,60.5,13.27,13.03,13.46,15.45,1974.47,
      3.42,0.21,13.79,14.89,32.37,3501; 110,41.64,67.5,15.99,13.46,13.47,
      15.46,2005.75,3.13,0.55,14.51,15.03,46.91,3611; 120,19.83,75.3,23.73,
      15.64,13.47,15.46,1991.2,3.04,1.25,16.91,15.62,58.56,3674; 130,28.25,
      77.8,28.98,16.95,13.49,15.93,2011.95,2.93,1.97,22.53,17.27,66.76,3700;
      140,44.9,78.7,56.0,30.29,13.5,16.59,1999.66,2.94,2.69,31.02,20.37,76.4,
      3700; 150,59.43,79.3,71.73,45.97,13.54,18.06,1983.6,3.04,3.0,39.77,
      24.48,87.63,3640; 161,67.08,79.6,76.72,56.01,13.61,21.79,1999.62,3.28,
      3.0,47.16,28.75,91.37,3625; 170,69.37,79.7,79.53,67.96,13.66,23.97,
      1985.44,3.25,3.0,52.36,32.55,100.0,3624; 180,70.07,79.6,79.79,69.81,
      13.73,28.0,1969.11,3.26,3.0,56.1,35.59,100.0,3618; 190,70.29,79.4,79.79,
      70.05,13.8,30.61,1967.51,3.28,3.0,58.71,37.79,100.0,3620; 200,70.29,
      79.3,79.67,70.4,13.84,33.47,1960.24,3.3,3.0,60.58,39.54,100.0,3615; 210,
      70.27,79.3,79.58,70.37,13.9,35.28,2001.11,3.29,3.0,61.95,40.85,100.0,
      3620; 220,70.27,79.4,79.63,70.35,13.93,36.51,1931.68,3.26,3.0,62.96,
      41.99,100.0,3611; 230,70.4,79.6,79.65,70.35,14.0,39.58,1991.66,3.24,3.0,
      63.77,42.93,100.0,3613; 240,70.58,79.8,79.92,70.51,14.02,40.53,1992.83,
      3.26,3.0,64.4,43.83,100.0,3613; 250,70.76,79.9,80.12,70.7,14.05,41.75,
      1977.13,3.26,3.0,64.98,44.62,100.0,3610; 261,70.93,80.0,80.19,70.76,
      14.09,43.24,1987.83,3.28,3.0,65.5,45.32,100.0,3610; 270,71.07,80.1,
      80.34,71.01,14.11,44.27,1960.15,3.24,3.0,65.93,45.77,100.0,3609; 281,
      71.14,80.1,80.46,71.15,14.15,45.11,1979.18,3.25,3.0,66.29,46.37,100.0,
      3609; 290,71.24,80.1,80.49,71.2,14.16,45.79,1999.94,3.26,3.0,66.6,46.84,
      100.0,3607; 301,71.28,80.1,80.51,71.29,14.18,46.51,2027.19,3.24,3.0,
      66.89,47.24,100.0,3605; 310,71.25,80.1,80.53,71.33,14.2,47.1,2004.47,
      3.26,3.0,67.13,47.49,100.0,3605; 320,71.32,80.2,80.53,71.34,14.21,47.54,
      1955.28,3.26,3.0,67.37,47.87,100.0,3607; 330,71.34,80.1,80.55,71.4,
      14.25,48.67,2023.19,3.26,3.0,67.53,48.27,100.0,3603; 340,71.36,80.1,
      80.56,71.43,14.27,49.19,2009.3,3.22,3.0,67.73,48.66,100.0,3597; 351,
      71.39,80.1,80.54,71.44,14.28,49.8,1955.09,3.27,3.0,67.87,48.98,100.0,
      3603; 360,71.41,80.0,80.53,71.45,14.31,50.55,1997.46,3.22,3.0,68.02,
      49.32,100.0,3601; 370,71.39,80.0,80.5,71.47,14.34,51.17,2026.8,3.24,3.0,
      68.13,49.59,100.0,3603; 380,71.34,79.9,80.47,71.46,14.37,51.5,1994.33,
      3.2,3.0,68.23,49.89,100.0,3597; 390,71.3,79.8,80.44,71.44,14.38,51.79,
      2007.62,3.24,3.0,68.35,50.01,100.0,3592; 401,71.28,79.8,80.34,71.39,
      14.39,52.4,1983.13,3.24,3.0,68.41,50.17,100.0,3594; 410,71.21,79.6,
      80.23,71.32,14.4,52.68,2009.01,3.21,3.0,68.46,50.43,100.0,3594; 420,
      71.12,79.4,80.13,71.3,14.41,52.94,2008.67,3.25,3.0,68.51,50.56,100.0,
      3597; 430,70.98,79.2,80.01,71.22,14.43,53.41,2000.81,3.24,3.0,68.51,
      50.76,100.0,3594; 441,70.85,79.0,79.78,71.04,14.44,53.76,2004.92,3.22,
      3.0,68.53,50.93,100.0,3597; 451,70.68,78.6,79.52,70.97,14.45,53.94,
      2010.09,3.24,3.0,68.51,51.23,100.0,3595; 460,70.4,78.1,79.52,70.92,
      14.47,54.14,1979.7,3.25,3.0,68.41,51.42,100.0,3595; 471,70.07,77.5,
      78.74,70.45,14.48,54.38,1972.71,3.23,3.0,68.25,51.5,100.0,3590; 480,
      69.63,77.0,78.15,70.08,14.5,54.59,2033.74,3.22,3.0,68.07,51.44,100.0,
      3593; 491,69.16,76.7,77.95,69.92,14.51,54.72,2011.6,3.24,3.0,67.84,
      51.39,100.0,3595; 501,68.82,76.6,77.24,69.12,14.53,55.24,1986.91,3.2,
      3.0,67.63,51.4,100.0,3585; 511,68.66,76.7,77.11,68.82,14.52,55.39,
      2004.58,3.25,3.0,67.45,51.5,100.0,3594; 520,68.65,76.8,77.11,68.77,
      14.53,55.45,2010.98,3.24,3.0,67.38,51.62,100.0,3590; 530,68.78,77.1,
      77.34,68.76,14.53,55.43,1987.7,3.25,3.0,67.35,51.69,100.0,3592; 541,
      68.92,77.3,77.58,68.91,14.54,55.49,1978.87,3.23,3.0,67.43,51.78,100.0,
      3589; 551,69.14,77.5,77.73,69.03,14.55,55.55,2022.68,3.22,3.0,67.57,
      51.98,100.0,3591; 561,69.32,77.7,77.89,69.18,14.56,55.63,1989.49,3.24,
      3.0,67.7,52.15,100.0,3589; 570,69.5,77.8,78.11,69.42,14.58,55.75,
      1995.31,3.24,3.0,67.87,52.28,100.0,3586; 581,69.64,77.9,78.22,69.55,
      14.59,55.82,2000.42,3.25,3.0,68.04,52.46,100.0,3588; 591,69.71,78.0,
      78.28,69.63,14.59,55.85,1987.92,3.22,3.0,68.19,52.64,100.0,3584; 601,
      69.8,78.0,78.45,69.8,14.61,56.12,2011.65,3.23,3.0,68.31,52.83,100.0,
      3587; 611,69.85,78.0,78.51,69.88,14.61,56.21,1989.81,3.24,3.0,68.42,
      53.01,100.0,3587; 620,69.88,78.0,78.52,69.91,14.62,56.32,2027.87,3.24,
      3.0,68.57,53.12,100.0,3584; 631,69.87,78.0,78.53,70.0,14.64,56.46,
      1986.31,3.22,3.0,68.64,53.23,100.0,3587; 641,69.9,78.0,78.52,69.98,
      14.66,56.64,1990.55,3.2,3.0,68.73,53.46,100.0,3587; 651,69.87,77.9,
      78.51,69.99,14.66,56.76,2000.89,3.21,3.0,68.76,53.67,100.0,3587; 661,
      69.81,77.9,78.44,69.94,14.67,56.89,2009.78,3.22,3.0,68.79,53.8,100.0,
      3583; 671,69.81,77.8,78.39,69.91,14.67,57.0,2016.46,3.26,3.0,68.85,
      53.89,100.0,3586; 681,69.79,77.8,78.37,69.9,14.68,57.14,1980.18,3.23,
      3.0,68.89,54.0,100.0,3580; 691,69.75,77.8,78.35,69.87,14.69,57.2,
      1962.75,3.22,3.0,68.92,54.09,100.0,3585; 701,69.76,77.8,78.31,69.84,
      14.69,57.33,1996.37,3.22,3.0,68.96,54.16,100.0,3586; 711,69.74,77.7,
      78.26,69.85,14.7,57.45,2017.72,3.23,3.0,69.01,54.28,100.0,3584; 721,
      69.7,77.6,78.25,69.85,14.72,57.61,2008.33,3.25,3.0,69.01,54.41,100.0,
      3585; 731,69.6,77.5,78.12,69.75,14.72,57.72,1978.15,3.23,3.0,69.0,54.53,
      100.0,3582; 741,69.55,77.3,78.02,69.67,14.73,57.79,2016.97,3.21,3.0,
      68.96,54.63,100.0,3580; 751,69.41,77.1,77.96,69.65,14.73,57.84,1994.96,
      3.24,3.0,68.91,54.82,100.0,3585; 761,69.26,76.9,77.67,69.47,14.75,57.93,
      2007.28,3.25,3.0,68.88,55.05,100.0,3582; 771,69.06,76.6,77.4,69.29,
      14.76,57.99,1994.93,3.21,3.0,68.81,55.1,100.0,3582; 781,68.89,76.5,
      77.25,69.16,14.76,58.08,1983.4,3.21,3.0,68.73,55.16,100.0,3585; 791,
      68.72,76.3,77.01,68.91,14.76,58.12,2026.88,3.23,3.0,68.64,55.24,100.0,
      3584; 801,68.57,76.3,76.89,68.75,14.75,58.27,1998.04,3.21,3.0,68.53,
      55.17,100.0,3582; 811,68.53,76.3,76.85,68.7,14.76,58.33,2010.51,3.24,
      3.0,68.46,55.2,100.0,3583; 821,68.53,76.4,76.84,68.65,14.77,58.33,
      2008.67,3.21,3.0,68.44,55.15,100.0,3586; 831,68.56,76.5,76.93,68.63,
      14.78,58.3,1965.93,3.23,3.0,68.44,55.16,100.0,3582; 841,68.67,76.6,77.0,
      68.64,14.79,58.28,1995.17,3.24,3.0,68.46,55.22,100.0,3575; 851,68.82,
      76.7,77.05,68.68,14.8,58.24,1999.87,3.24,3.0,68.56,55.29,100.0,3576;
      861,68.86,76.7,77.17,68.91,14.81,58.17,2009.21,3.28,3.0,68.63,55.39,
      100.0,3576; 871,68.91,76.8,77.24,68.95,14.81,58.19,1982.73,3.24,3.0,
      68.69,55.48,100.0,3576; 881,68.94,76.8,77.24,68.97,14.81,58.25,2018.06,
      3.25,3.0,68.75,55.58,100.0,3575; 891,68.98,76.8,77.27,69.06,14.82,58.28,
      1978.42,3.23,3.0,68.8,55.64,100.0,3572; 901,69.01,76.8,77.3,69.06,14.83,
      58.38,2007.12,3.24,3.0,68.88,55.73,100.0,3574; 911,69.01,76.8,77.33,
      69.09,14.84,58.43,2016.59,3.26,3.0,68.94,55.83,100.0,3574; 921,69.03,
      76.8,77.33,69.09,14.84,58.52,1986.49,3.25,3.0,69.01,55.93,100.0,3572;
      931,69.08,76.8,77.34,69.1,14.84,58.64,2020.21,3.26,3.0,69.07,56.02,
      100.0,3569; 941,69.03,76.8,77.32,69.12,14.84,58.69,2009.0,3.24,3.0,
      69.08,56.08,100.0,3573; 951,69.0,76.8,77.29,69.1,14.84,58.75,2024.4,
      3.23,3.0,69.12,56.2,100.0,3571; 961,68.98,76.8,77.27,69.07,14.84,58.84,
      1996.12,3.25,3.0,69.14,56.26,100.0,3562; 971,68.98,76.7,77.27,69.06,
      14.85,58.95,1982.87,3.24,3.0,69.16,56.39,100.0,3571; 981,68.98,76.7,
      77.26,69.05,14.85,58.99,1980.13,3.24,3.0,69.16,56.42,100.0,3568; 991,
      68.94,76.7,77.24,69.05,14.85,59.01,2011.44,3.2,3.0,69.16,56.52,100.0,
      3568; 1001,68.93,76.6,77.2,69.05,14.86,59.02,2010.12,3.22,3.0,69.17,
      56.59,100.0,3569; 1011,68.88,76.5,77.16,69.02,14.87,59.04,1980.72,3.26,
      3.0,69.17,56.74,100.0,3567; 1021,68.84,76.5,77.06,68.96,14.88,59.09,
      2013.08,3.24,3.0,69.17,56.75,100.0,3567; 1031,68.76,76.4,76.98,68.89,
      14.9,59.13,1971.62,3.24,3.0,69.13,56.79,100.0,3574; 1041,68.73,76.4,
      76.96,68.86,14.91,59.14,1997.04,3.24,3.0,69.16,56.82,100.0,3571; 1051,
      68.73,76.4,76.95,68.83,14.91,59.16,2021.25,3.22,3.0,69.16,56.85,100.0,
      3571; 1061,68.7,76.3,76.93,68.79,14.92,59.17,2009.66,3.25,3.0,69.14,
      56.92,100.0,3572; 1071,68.67,76.3,76.88,68.77,14.92,59.22,2002.77,3.23,
      3.0,69.11,56.96,100.0,3571; 1081,68.62,76.2,76.85,68.76,14.92,59.24,
      1983.45,3.26,3.0,69.12,57.05,100.0,3570; 1091,68.6,76.2,76.79,68.71,
      14.93,59.25,1999.66,3.23,3.0,69.08,57.08,100.0,3571; 1101,68.57,76.2,
      76.77,68.69,14.93,59.27,1996.16,3.23,3.0,69.08,57.13,100.0,3568; 1111,
      68.57,76.2,76.77,68.68,14.92,59.29,2001.35,3.24,3.0,69.08,57.15,100.0,
      3569; 1121,68.59,76.2,76.77,68.65,14.93,59.31,1996.8,3.23,3.0,69.08,
      57.19,100.0,3565; 1131,68.61,76.3,76.79,68.67,14.94,59.33,1994.67,3.23,
      3.0,69.11,57.21,100.0,3571; 1141,68.61,76.3,76.8,68.69,14.93,59.37,
      2011.42,3.23,3.0,69.13,57.25,100.0,3573; 1151,68.61,76.3,76.8,68.69,
      14.93,59.44,1995.49,3.26,3.0,69.16,57.35,100.0,3567; 1161,68.61,76.3,
      76.8,68.69,14.93,59.55,1998.91,3.24,3.0,69.18,57.42,100.0,3570; 1171,
      68.62,76.3,76.8,68.7,14.93,59.58,1997.2,3.25,3.0,69.23,57.43,100.0,3571;
      1181,68.61,76.3,76.81,68.71,14.93,59.59,2012.22,3.23,3.0,69.22,57.45,
      100.0,3568; 1192,68.61,76.4,76.81,68.71,14.94,59.59,2002.81,3.25,3.0,
      69.23,57.53,100.0,3569; 1201,68.62,76.5,76.85,68.7,14.94,59.59,2005.34,
      3.25,3.0,69.25,57.62,100.0,3569; 1211,68.73,76.6,76.95,68.74,14.94,59.6,
      1986.85,3.26,3.0,69.32,57.69,100.0,3567; 1221,68.84,76.7,77.08,68.84,
      14.94,59.61,1993.14,3.24,3.0,69.39,57.73,100.0,3567; 1231,68.96,76.7,
      77.19,68.94,14.95,59.62,2026.7,3.25,3.0,69.5,57.76,100.0,3571; 1241,
      69.0,76.8,77.21,68.99,14.96,59.65,2008.35,3.23,3.0,69.55,57.87,100.0,
      3570; 1251,69.05,76.8,77.27,69.06,14.97,59.68,1999.61,3.25,3.0,69.58,
      57.95,100.0,3571; 1261,69.08,76.8,77.33,69.14,14.98,59.73,2003.22,3.24,
      3.0,69.65,58.05,100.0,3568; 1271,69.1,76.8,77.35,69.17,14.99,59.82,
      1975.03,3.22,3.0,69.71,58.07,100.0,3567; 1281,69.1,76.8,77.35,69.18,
      15.0,59.92,1995.14,3.24,3.0,69.76,58.08,100.0,3566; 1291,69.11,76.8,
      77.34,69.18,15.0,59.95,1987.39,3.22,3.0,69.77,58.06,100.0,3570; 1301,
      69.1,76.8,77.34,69.18,15.0,60.01,2013.15,3.25,3.0,69.8,58.07,100.0,3568;
      1311,69.05,76.8,77.31,69.18,15.01,60.12,1995.73,3.25,3.0,69.83,58.13,
      100.0,3569; 1321,69.1,76.8,77.28,69.17,15.01,60.16,2000.02,3.22,3.0,
      69.84,58.25,100.0,3571; 1331,69.03,76.7,77.27,69.16,15.02,60.23,2025.19,
      3.22,3.0,69.84,58.26,100.0,3570; 1341,69.01,76.7,77.26,69.15,15.02,
      60.26,1980.75,3.25,3.0,69.87,58.36,100.0,3569; 1352,69.06,76.7,77.23,
      69.12,15.02,60.27,2022.95,3.22,3.0,69.87,58.39,100.0,3570; 1361,69.03,
      76.8,77.23,69.12,15.02,60.27,2011.42,3.25,3.0,69.87,58.42,100.0,3568;
      1371,69.01,76.9,77.23,69.11,15.02,60.3,1961.72,3.22,3.0,69.89,58.46,
      100.0,3566; 1381,69.16,77.0,77.35,69.14,15.01,60.33,2006.98,3.23,3.0,
      69.94,58.52,100.0,3572; 1391,69.19,77.1,77.49,69.24,15.02,60.33,1982.54,
      3.23,3.0,69.98,58.54,100.0,3568; 1401,69.31,77.2,77.55,69.27,15.03,
      60.37,2016.69,3.25,3.0,70.05,58.62,100.0,3569; 1411,69.42,77.2,77.67,
      69.41,15.03,60.43,2011.3,3.24,3.0,70.12,58.67,100.0,3569; 1422,69.46,
      77.3,77.75,69.48,15.04,60.52,2018.6,3.21,3.0,70.18,58.71,100.0,3564;
      1431,69.5,77.3,77.78,69.54,15.04,60.62,1999.88,3.23,3.0,70.24,58.8,
      100.0,3566; 1441,69.53,77.3,77.81,69.58,15.04,60.69,2007.43,3.26,3.0,
      70.31,58.9,100.0,3566; 1452,69.55,77.4,77.85,69.61,15.05,60.82,2007.42,
      3.24,3.0,70.37,58.95,100.0,3566; 1461,69.55,77.4,77.88,69.64,15.06,
      60.86,2007.73,3.23,3.0,70.38,59.01,100.0,3571; 1472,69.58,77.4,77.88,
      69.64,15.07,60.93,1996.89,3.24,3.0,70.4,59.06,100.0,3569; 1481,69.64,
      77.5,77.92,69.7,15.08,60.97,2011.53,3.24,3.0,70.45,59.1,100.0,3570;
      1492,69.65,77.5,77.95,69.73,15.09,60.98,2008.26,3.23,3.0,70.5,59.12,
      100.0,3568; 1502,69.69,77.6,77.97,69.73,15.1,61.0,2001.0,3.23,3.0,70.55,
      59.21,100.0,3566; 1511,69.7,77.6,78.05,69.76,15.09,61.0,1998.18,3.22,
      3.0,70.61,59.31,100.0,3566; 1522,69.77,77.6,78.08,69.8,15.09,61.01,
      2003.86,3.21,3.0,70.65,59.36,100.0,3565; 1531,69.8,77.6,78.1,69.85,
      15.08,61.06,2024.88,3.26,3.0,70.71,59.44,100.0,3566; 1542,69.8,77.7,
      78.13,69.86,15.08,61.09,2019.22,3.25,3.0,70.73,59.44,100.0,3567; 1552,
      69.82,77.7,78.18,69.9,15.08,61.1,1995.59,3.23,3.0,70.76,59.53,100.0,
      3565; 1562,69.86,77.7,78.2,69.92,15.08,61.12,2010.92,3.22,3.0,70.8,59.5,
      100.0,3569; 1571,69.85,77.7,78.21,69.95,15.08,61.14,2017.84,3.25,3.0,
      70.82,59.61,100.0,3565; 1581,69.9,77.7,78.21,69.96,15.1,61.16,2007.5,
      3.24,3.0,70.86,59.67,100.0,3566; 1592,69.91,77.7,78.21,69.98,15.1,61.2,
      1978.24,3.21,3.0,70.88,59.72,100.0,3563; 1602,69.93,77.7,78.22,69.99,
      15.1,61.26,1966.65,3.26,3.0,70.94,59.76,100.0,3569; 1612,69.94,77.8,
      78.25,70.02,15.11,61.34,2026.47,3.23,3.0,70.96,59.82,100.0,3569; 1621,
      69.91,77.8,78.26,70.04,15.11,61.38,2015.61,3.24,3.0,70.94,59.88,100.0,
      3567; 1632,69.96,77.8,78.26,70.03,15.12,61.41,1980.62,3.25,3.0,70.96,
      59.87,100.0,3568; 1642,69.97,77.8,78.3,70.04,15.13,61.42,2005.39,3.26,
      3.0,70.98,59.86,100.0,3567; 1651,69.97,77.8,78.33,70.06,15.14,61.47,
      2002.53,3.23,3.0,71.0,59.94,100.0,3565; 1662,70.01,77.9,78.34,70.07,
      15.15,61.49,1996.42,3.24,3.0,71.05,59.92,100.0,3568; 1671,70.07,78.0,
      78.37,70.1,15.15,61.55,2006.79,3.21,3.0,71.1,59.97,100.0,3566; 1682,
      70.1,78.0,78.46,70.15,15.15,61.67,1969.72,3.23,3.0,71.13,60.0,100.0,
      3565; 1692,70.13,78.0,78.49,70.17,15.16,61.76,2012.15,3.22,3.0,71.15,
      60.12,100.0,3569; 1702,70.16,78.1,78.51,70.23,15.17,61.83,1990.75,3.25,
      3.0,71.19,60.22,100.0,3566; 1712,70.2,78.1,78.57,70.28,15.18,61.89,
      1980.31,3.23,3.0,71.21,60.27,100.0,3568; 1721,70.21,78.1,78.6,70.3,
      15.18,62.0,1978.89,3.21,3.0,71.24,60.36,100.0,3563; 1731,70.26,78.1,
      78.62,70.31,15.18,62.05,1995.21,3.22,3.0,71.28,60.35,100.0,3566; 1741,
      70.27,78.2,78.63,70.36,15.19,62.1,2030.82,3.2,3.0,71.31,60.36,100.0,
      3567; 1752,70.27,78.2,78.65,70.35,15.19,62.14,1988.18,3.24,3.0,71.35,
      60.37,100.0,3564; 1762,70.32,78.2,78.67,70.36,15.2,62.17,1978.08,3.26,
      3.0,71.37,60.36,100.0,3567; 1772,70.36,78.3,78.74,70.43,15.2,62.17,
      2005.14,3.23,3.0,71.41,60.38,100.0,3566; 1781,70.4,78.3,78.76,70.44,
      15.2,62.17,2012.22,3.23,3.0,71.42,60.41,100.0,3568; 1791,70.38,78.3,
      78.78,70.45,15.21,62.17,2015.48,3.2,3.0,71.44,60.44,100.0,3568; 1802,
      70.42,78.4,78.8,70.46,15.21,62.22,1987.45,3.22,3.0,71.49,60.5,100.0,
      3565; 1812,70.46,78.4,78.85,70.53,15.22,62.28,1984.24,3.23,3.0,71.5,
      60.58,100.0,3567; 1822,70.5,78.4,78.89,70.57,15.22,62.35,2002.45,3.24,
      3.0,71.57,60.64,100.0,3563; 1831,70.53,78.5,78.92,70.59,15.22,62.4,
      1995.32,3.23,3.0,71.61,60.71,100.0,3569; 1842,70.58,78.5,78.95,70.66,
      15.22,62.47,2008.2,3.24,3.0,71.66,60.71,100.0,3565; 1852,70.58,78.5,
      79.0,70.68,15.22,62.49,1986.99,3.22,3.0,71.69,60.74,100.0,3568; 1862,
      70.58,78.5,79.01,70.67,15.22,62.51,1990.91,3.21,3.0,71.74,60.79,100.0,
      3561; 1872,70.64,78.5,79.04,70.7,15.22,62.53,1999.1,3.21,3.0,71.76,60.8,
      100.0,3568; 1881,70.69,78.6,79.05,70.72,15.22,62.53,1997.62,3.23,3.0,
      71.8,60.9,100.0,3563; 1892,70.69,78.6,79.06,70.74,15.22,62.57,2016.41,
      3.26,3.0,71.8,60.97,100.0,3566; 1902,70.68,78.6,79.07,70.75,15.22,62.6,
      1985.04,3.23,3.0,71.82,60.99,100.0,3565; 1912,70.73,78.6,79.13,70.77,
      15.23,62.61,1999.48,3.24,3.0,71.85,61.01,100.0,3565; 1922,70.71,78.7,
      79.16,70.82,15.24,62.64,1999.9,3.23,3.0,71.87,61.08,100.0,3564; 1932,
      70.76,78.7,79.18,70.83,15.25,62.67,1990.65,3.24,3.0,71.91,61.09,100.0,
      3562; 1942,70.76,78.7,79.21,70.86,15.27,62.7,1996.55,3.22,3.0,71.92,
      61.14,100.0,3566; 1952,70.81,78.8,79.22,70.86,15.27,62.74,1974.53,3.23,
      3.0,71.98,61.19,100.0,3567; 1962,70.84,78.8,79.23,70.86,15.26,62.78,
      2000.16,3.24,3.0,72.02,61.19,100.0,3566; 1972,70.86,78.8,79.31,70.93,
      15.26,62.79,1986.28,3.27,3.0,72.07,61.17,100.0,3561; 1982,70.91,78.9,
      79.33,70.98,15.26,62.8,2009.69,3.22,3.0,72.08,61.21,100.0,3564; 1992,
      70.91,78.9,79.34,70.99,15.27,62.8,2007.66,3.25,3.0,72.1,61.21,100.0,
      3562; 2002,70.92,78.9,79.36,71.01,15.27,62.79,1986.69,3.21,3.0,72.14,
      61.29,100.0,3563; 2012,71.01,78.9,79.43,71.02,15.27,62.79,2028.52,3.24,
      3.0,72.19,61.35,100.0,3563; 2022,71.03,79.0,79.46,71.09,15.27,62.82,
      2004.91,3.22,3.0,72.23,61.35,100.0,3563; 2032,71.05,79.0,79.47,71.12,
      15.27,62.87,1993.85,3.24,3.0,72.26,61.41,100.0,3560; 2042,71.09,79.0,
      79.49,71.15,15.26,62.91,2016.98,3.24,3.0,72.32,61.45,100.0,3562; 2052,
      71.08,79.1,79.51,71.17,15.26,62.93,2014.77,3.26,3.0,72.32,61.4,100.0,
      3561; 2062,71.1,79.1,79.55,71.17,15.27,62.99,2011.37,3.24,3.0,72.32,
      61.45,100.0,3564; 2072,71.14,79.1,79.59,71.19,15.28,63.03,1992.7,3.24,
      3.0,72.37,61.52,100.0,3564; 2082,71.19,79.2,79.62,71.24,15.29,63.06,
      1968.02,3.22,3.0,72.41,61.53,100.0,3564; 2092,71.21,79.2,79.62,71.26,
      15.3,63.07,1989.15,3.25,3.0,72.45,61.57,100.0,3558; 2102,71.24,79.2,
      79.71,71.31,15.3,63.12,1997.99,3.27,3.0,72.48,61.63,100.0,3566; 2112,
      71.29,79.3,79.74,71.35,15.3,63.18,1994.83,3.24,3.0,72.49,61.7,100.0,
      3561; 2122,71.3,79.3,79.75,71.37,15.3,63.25,1989.9,3.24,3.0,72.52,61.76,
      100.0,3561; 2132,71.34,79.3,79.8,71.4,15.31,63.31,1981.8,3.25,3.0,72.56,
      61.81,100.0,3566; 2142,71.37,79.4,79.82,71.42,15.32,63.37,2009.27,3.24,
      3.0,72.59,61.81,100.0,3562; 2152,71.39,79.4,79.87,71.45,15.32,63.42,
      2008.58,3.24,3.0,72.64,61.87,100.0,3562; 2162,71.39,79.4,79.9,71.47,
      15.32,63.48,2012.67,3.22,3.0,72.65,61.87,100.0,3564; 2172,71.46,79.5,
      79.91,71.47,15.32,63.52,1992.54,3.24,3.0,72.69,61.9,100.0,3564; 2182,
      71.48,79.5,79.94,71.54,15.33,63.55,2006.1,3.22,3.0,72.69,61.87,97.7,
      3559; 2192,71.49,79.5,79.98,71.57,15.35,63.58,2002.14,3.24,3.0,72.73,
      62.0,84.32,3569; 2202,71.35,79.5,80.02,71.57,15.34,63.62,2024.09,3.12,
      3.0,72.75,62.02,74.82,3615; 2212,70.92,79.6,79.85,71.29,15.34,63.64,
      2012.14,2.94,2.51,72.67,62.12,62.88,3649; 2222,70.38,79.5,79.48,71.14,
      15.34,63.64,2025.6,2.97,1.79,72.3,62.06,55.97,3653; 2232,69.53,79.5,
      76.06,69.82,15.34,63.61,2001.37,3.04,1.0,71.49,61.83,41.58,3624; 2242,
      68.83,79.4,73.65,68.67,15.33,63.43,2018.7,3.25,0.43,70.07,61.43,33.24,
      3563; 2252,68.48,79.3,70.38,66.81,15.33,63.29,2019.28,3.43,0.13,68.1,
      60.81,23.02,3465; 2262,68.39,79.2,63.79,61.8,15.32,62.72,2003.64,3.89,
      0.02,65.73,59.88,13.81,3411; 2272,68.44,79.1,60.86,59.21,15.31,62.13,
      1992.2,3.98,0.0,63.2,58.8,3.02,3428; 2282,68.48,79.0,56.58,55.17,15.3,
      61.54,2017.53,3.96,0.0,60.54,57.51,0.0,3425; 2292,68.48,78.9,52.22,
      50.96,15.28,60.54,2025.33,4.05,0.0,57.95,56.17,0.0,3391; 2302,68.39,
      78.7,50.07,48.9,15.25,59.63,1994.66,4.01,0.0,55.47,54.82,0.0,3422; 2312,
      68.29,78.4,47.85,46.73,15.23,58.75,2020.52,2.77,0.0,53.12,53.47,0.0,
      3415; 2322,68.16,78.2,46.87,45.77,15.19,57.46,1968.41,4.02,0.0,50.92,
      52.15,0.0,3449; 2332,67.99,78.0,42.33,41.36,15.16,56.23,2023.91,3.96,
      0.0,48.81,50.88,0.0,3407; 2342,67.87,77.8,39.89,38.97,15.13,54.71,
      2005.42,3.99,0.0,46.86,49.61,0.0,3414; 2352,67.71,77.6,39.16,38.28,
      15.11,53.31,2020.8,3.99,0.0,45.05,48.38,0.0,3401; 2362,67.59,77.4,36.17,
      35.35,15.08,52.04,1994.63,3.99,0.0,43.33,47.19,0.0,3470; 2372,67.47,
      77.2,35.02,34.22,15.05,51.02,2003.55,3.99,0.0,41.73,46.11,0.0,3482;
      2383,67.35,77.0,33.59,32.84,15.02,49.61,2025.39,3.99,0.0,40.25,45.14,
      0.0,3427; 2392,67.25,76.7,31.67,30.97,15.0,48.14,2004.18,3.99,0.0,38.84,
      44.18,0.0,3428; 2402,67.12,76.5,30.77,30.1,14.96,47.32,1990.38,3.99,0.0,
      37.54,43.19,0.0,3442; 2412,67.01,76.3,29.45,28.79,14.94,46.42,2007.02,
      3.99,0.0,36.32,42.24,0.0,3421; 2422,66.9,76.1,28.69,28.03,14.92,45.19,
      1995.15,3.99,0.0,35.17,41.39,0.0,3407; 2432,66.8,75.9,27.32,26.75,14.89,
      43.56,1997.02,3.99,0.0,34.14,40.58,0.0,3444; 2442,66.68,75.8,26.39,
      25.84,14.87,42.73,2007.34,3.99,0.0,33.16,39.78,0.0,3407; 2452,66.57,
      75.6,26.07,25.54,14.87,42.11,2021.55,3.99,0.0,32.21,38.91,0.0,3426;
      2462,66.46,75.3,24.77,24.26,14.84,40.74,2000.38,3.99,0.0,31.37,38.16,
      0.0,3450; 2472,66.35,75.1,24.25,23.77,14.82,40.0,2007.37,3.99,0.0,30.56,
      37.49,0.0,3473; 2482,66.24,74.9,23.71,23.24,14.8,39.03,1997.12,3.99,0.0,
      29.82,36.78,0.0,3413; 2492,66.13,74.6,22.68,22.22,14.78,38.2,2009.76,
      3.99,0.0,29.1,36.16,0.0,3432; 2502,66.03,74.4,22.47,22.02,14.76,37.16,
      1999.33,3.99,0.0,28.45,35.56,0.0,3465; 2512,65.9,74.3,21.74,21.32,14.74,
      36.78,2041.83,3.99,0.0,27.83,35.12,0.0,3453; 2523,65.8,74.0,21.4,20.98,
      14.72,35.67,1965.83,3.93,0.0,27.26,34.71,0.0,3441; 2532,65.69,73.8,
      20.79,20.37,14.71,35.04,2010.09,3.76,0.0,26.72,34.12,0.0,3437; 2542,
      65.58,73.6,20.3,19.9,14.7,34.51,1997.45,3.84,0.0,26.23,33.47,0.0,3415;
      2552,65.48,73.4,20.03,19.65,14.68,33.81,1988.84,3.85,0.0,25.73,33.0,0.0,
      3422; 2562,65.37,73.3,19.6,19.21,14.66,33.15,2006.48,3.84,0.0,25.3,
      32.59,0.0,3435; 2572,65.26,73.1,19.2,18.81,14.65,32.68,1998.71,3.87,0.0,
      24.87,32.07,0.0,3435; 2582,65.15,72.9,19.09,18.71,14.64,32.28,1996.44,
      3.82,0.0,24.46,31.59,0.0,3403; 2593,65.07,72.7,18.59,18.23,14.62,31.59,
      2002.35,3.73,0.0,24.06,31.17,0.0,3429; 2602,64.93,72.4,18.38,18.05,
      14.61,30.95,1968.0,1.78,0.0,23.69,30.74,0.0,3452; 2613,64.84,72.2,18.19,
      17.84,14.6,30.57,1998.06,0.76,0.0,23.37,30.37,0.0,3432; 2622,64.74,72.1,
      17.81,17.48,14.59,29.98,2015.77,2.92,0.0,23.02,30.0,0.0,3439; 2632,64.6,
      71.9,17.66,17.33,14.58,29.75,2001.5,3.37,0.0,22.74,29.57,0.0,3436; 2643,
      64.53,71.7,17.43,17.09,14.57,29.11,1986.53,3.86,0.0,22.47,29.25,0.0,
      3407; 2652,64.42,71.5,17.29,16.96,14.57,28.82,2011.44,3.98,0.0,22.17,
      28.91,0.0,3398; 2663,64.31,71.3,17.04,16.74,14.56,28.38,1989.35,3.81,
      0.0,21.9,28.64,0.0,3455; 2672,64.21,71.1,16.91,16.6,14.55,27.93,2005.07,
      3.83,0.0,21.66,28.29,0.0,3416; 2683,64.1,70.9,16.86,16.53,14.55,27.79,
      1979.33,3.86,0.0,21.43,27.95,0.0,3395; 2693,64.01,70.7,16.57,16.26,
      14.53,27.34,1979.63,3.72,0.0,21.22,27.65,0.0,3431; 2702,63.92,70.5,
      16.41,16.1,14.52,26.96,1985.54,3.72,0.0,20.98,27.37,0.0,3411; 2713,
      63.81,70.4,16.35,16.07,14.51,26.71,2016.65,3.85,0.0,20.79,27.12,0.0,
      3425; 2722,63.72,70.1,16.17,15.86,14.5,26.3,2005.13,3.88,0.0,20.59,
      26.86,0.0,3420; 2733,63.61,70.0,16.04,15.74,14.49,26.04,2010.29,3.84,
      0.0,20.41,26.55,0.0,3409; 2742,63.53,69.8,15.99,15.69,14.48,25.7,1995.7,
      3.75,0.0,20.25,26.31,0.0,3475; 2752,63.44,69.6,15.85,15.54,14.47,25.49,
      2007.01,3.79,0.0,20.07,26.03,0.0,3447; 2763,63.32,69.5,15.76,15.45,
      14.47,25.16,2015.92,3.83,0.0,19.89,25.73,0.0,3442; 2773,63.25,69.3,
      15.66,15.38,14.46,24.96,2019.56,3.89,0.0,19.76,25.45,0.0,3447; 2782,
      63.15,69.1,15.62,15.34,14.44,24.69,1988.68,3.75,0.0,19.58,25.28,0.0,
      3430; 2792,63.06,69.0,15.49,15.23,14.44,24.44,2006.2,3.84,0.0,19.44,
      25.0,0.0,3453; 2803,62.94,68.8,15.43,15.14,14.43,24.25,1983.77,3.81,0.0,
      19.3,24.83,0.0,3443; 2813,62.89,68.6,15.4,15.12,14.42,24.07,2015.25,
      3.88,0.0,19.15,24.67,0.0,3438; 2822,62.78,68.5,15.3,15.01,14.41,23.83,
      1970.48,3.71,0.0,19.03,24.53,0.0,3470; 2832,62.67,68.3,15.21,14.96,
      14.41,23.54,1965.69,3.87,0.0,18.9,24.32,0.0,3406; 2842,62.6,68.1,15.21,
      14.94,14.4,23.38,2002.96,3.82,0.0,18.77,24.17,0.0,3422; 2853,62.5,67.9,
      15.1,14.84,14.4,23.26,1977.71,3.91,0.0,18.68,24.02,0.0,3401; 2863,62.41,
      67.7,15.07,14.81,14.39,22.99,2009.69,3.76,0.0,18.55,23.78,0.0,3418;
      2873,62.33,67.6,15.04,14.75,14.39,22.92,2006.62,3.81,0.0,18.44,23.59,
      0.0,3460; 2882,62.23,67.4,14.96,14.7,14.38,22.68,2004.49,3.72,0.0,18.36,
      23.47,0.0,3404; 2893,62.15,67.2,14.93,14.68,14.38,22.5,1987.86,3.71,0.0,
      18.25,23.35,0.0,3430; 2903,62.05,67.1,14.9,14.64,14.38,22.36,1961.42,
      3.7,0.0,18.16,23.24,0.0,3466; 2913,61.97,66.9,14.85,14.6,14.38,22.24,
      2007.47,3.85,0.0,18.07,23.08,0.0,3414; 2923,61.89,66.7,14.8,14.55,14.37,
      22.06,1966.65,3.84,0.0,17.96,22.98,0.0,3424; 2932,61.78,66.6,14.79,
      14.53,14.36,21.92,2044.38,3.78,0.0,17.89,22.82,0.0,3455; 2943,61.71,
      66.4,14.78,14.51,14.35,21.77,1984.23,3.9,0.0,17.8,22.72,0.0,3436; 2953,
      61.63,66.2,14.71,14.44,14.35,21.62,2020.22,3.8,0.0,17.69,22.56,0.0,3452;
      2963,61.56,66.1,14.66,14.42,14.34,21.5,1996.38,3.81,0.0,17.63,22.43,0.0,
      3420; 2973,61.5,65.9,14.66,14.41,14.33,21.4,1999.64,3.72,0.0,17.53,22.3,
      0.0,3457; 2982,61.39,65.7,14.63,14.37,14.33,21.28,1986.25,3.78,0.0,
      17.46,22.14,0.0,3412; 2993,61.3,65.6,14.6,14.33,14.33,21.14,2025.86,
      3.91,0.0,17.39,22.02,0.0,3465; 3003,61.23,65.5,14.56,14.3,14.33,21.01,
      1976.85,3.85,0.0,17.31,21.87,0.0,3404; 3013,61.13,65.3,14.53,14.29,
      14.32,20.89,2014.63,3.81,0.0,17.25,21.69,0.0,3424; 3023,61.06,65.1,
      14.52,14.28,14.32,20.83,1994.73,3.89,0.0,17.17,21.57,0.0,3452; 3033,
      60.97,64.9,14.52,14.25,14.32,20.7,1978.12,3.81,0.0,17.09,21.46,0.0,3447;
      3043,60.91,64.8,14.49,14.24,14.31,20.63,1990.26,3.78,0.0,17.04,21.31,
      0.0,3421; 3052,60.84,64.7,14.46,14.21,14.31,20.57,2010.52,3.77,0.0,
      16.99,21.19,0.0,3397; 3063,60.76,64.5,14.43,14.17,14.31,20.43,2009.45,
      3.87,0.0,16.92,21.07,0.0,3452; 3073,60.69,64.4,14.42,14.17,14.31,20.31,
      2013.18,3.9,0.0,16.87,20.93,0.0,3416; 3083,60.62,64.2,14.39,14.15,14.31,
      20.25,1946.84,3.82,0.0,16.81,20.85,0.0,3416; 3092,60.52,64.1,14.39,
      14.15,14.3,20.16,2003.33,3.79,0.0,16.75,20.77,0.0,3406; 3103,60.46,63.9,
      14.38,14.14,14.29,20.04,2005.7,3.82,0.0,16.69,20.64,0.0,3421; 3113,
      60.39,63.7,14.38,14.12,14.29,20.0,2011.44,3.72,0.0,16.64,20.53,0.0,3415;
      3123,60.3,63.6,14.38,14.12,14.29,19.89,2022.67,3.82,0.0,16.59,20.44,0.0,
      3403; 3132,60.23,63.4,14.36,14.09,14.29,19.82,2007.79,3.78,0.0,16.54,
      20.33,0.0,3444; 3142,60.14,63.3,14.35,14.09,14.29,19.76,1995.1,3.82,0.0,
      16.49,20.28,0.0,3424; 3153,60.1,63.1,14.31,14.05,14.29,19.67,1996.06,
      3.67,0.0,16.44,20.21,0.0,3435; 3163,60.02,63.0,14.29,14.04,14.28,19.59,
      1993.36,3.89,0.0,16.38,20.12,0.0,3451; 3173,59.93,62.8,14.28,14.03,
      14.27,19.54,2004.83,3.76,0.0,16.34,20.03,0.0,3450; 3182,59.9,62.7,14.27,
      14.03,14.27,19.43,2041.93,3.79,0.0,16.28,19.93,0.0,3444; 3192,59.81,
      62.6,14.25,14.01,14.27,19.4,2000.91,3.88,0.0,16.26,19.85,0.0,3425; 3203,
      59.74,62.4,14.25,14.01,14.26,19.32,2005.43,3.7,0.0,16.21,19.76,0.0,3414;
      3213,59.68,62.3,14.24,13.99,14.26,19.27,1996.94,3.84,0.0,16.16,19.64,
      0.0,3429; 3223,59.6,62.1,14.24,13.98,14.26,19.18,2010.65,3.87,0.0,16.12,
      19.61,0.0,3417; 3232,59.53,62.0,14.25,13.98,14.26,19.12,2024.75,3.86,
      0.0,16.08,19.55,0.0,3408; 3243,59.46,61.8,14.23,13.97,14.26,19.05,
      2011.32,3.9,0.0,16.04,19.42,0.0,3417; 3253,59.37,61.7,14.22,13.96,14.26,
      18.99,1986.89,3.73,0.0,15.99,19.35,0.0,3447; 3262,59.31,61.6,14.21,
      13.95,14.25,18.92,2033.7,3.84,0.0,15.96,19.29,0.0,3400; 3273,59.24,61.4,
      14.2,13.93,14.26,18.87,2007.19,3.86,0.0,15.92,19.19,0.0,3442; 3283,
      59.18,61.3,14.19,13.92,14.26,18.85,2002.08,3.76,0.0,15.88,19.15,0.0,
      3409; 3293,59.1,61.1,14.18,13.92,14.25,18.77,1963.1,3.83,0.0,15.85,
      19.09,0.0,3432; 3303,59.04,61.0,14.16,13.89,14.25,18.71,2021.66,3.79,
      0.0,15.81,19.03,0.0,3449; 3313,58.95,60.9,14.15,13.89,14.25,18.67,
      2018.45,3.87,0.0,15.79,18.93,0.0,3453; 3323,58.89,60.7,14.15,13.89,
      14.25,18.61,1994.53,3.74,0.0,15.75,18.83,0.0,3453; 3333,58.82,60.6,
      14.14,13.89,14.24,18.57,2004.04,3.85,0.0,15.73,18.77,0.0,3437; 3343,
      58.76,60.5,14.14,13.88,14.24,18.51,1999.1,3.81,0.0,15.69,18.74,0.0,3483;
      3353,58.69,60.3,14.13,13.88,14.24,18.47,2001.29,3.85,0.0,15.67,18.71,
      0.0,3413; 3363,58.64,60.2,14.13,13.88,14.23,18.4,2001.44,3.75,0.0,15.6,
      18.66,0.0,3449; 3373,58.56,60.1,14.13,13.88,14.23,18.37,1984.69,3.81,
      0.0,15.58,18.6,0.0,3429; 3383,58.53,59.9,14.12,13.87,14.24,18.32,
      1983.95,3.87,0.0,15.55,18.55,0.0,3414; 3393,58.44,59.8,14.12,13.87,
      14.24,18.28,2011.75,3.65,0.0,15.53,18.5,0.0,3420; 3403,58.38,59.6,14.11,
      13.86,14.24,18.25,1992.61,3.9,0.0,15.51,18.47,0.0,3421; 3413,58.31,59.5,
      14.11,13.86,14.24,18.21,2007.32,3.76,0.0,15.48,18.38,0.0,3428; 3423,
      58.26,59.4,14.11,13.86,14.23,18.18,2013.78,3.86,0.0,15.44,18.32,0.0,
      3419; 3433,58.17,59.2,14.11,13.86,14.23,18.14,1999.92,3.95,0.0,15.42,
      18.21,0.0,3409; 3443,58.11,59.1,14.11,13.85,14.22,18.1,1979.13,3.63,0.0,
      15.39,18.17,0.0,3412; 3453,58.04,59.0,14.11,13.85,14.22,18.07,1998.75,
      3.8,0.0,15.39,18.12,0.0,3413; 3463,57.99,58.9,14.11,13.85,14.22,18.03,
      2014.02,3.59,0.0,15.35,18.1,0.0,3418; 3473,57.92,58.7,14.11,13.84,14.22,
      18.0,2003.27,3.71,0.0,15.33,18.03,0.0,3412; 3483,57.88,58.6,14.11,13.82,
      14.22,17.96,2023.07,3.65,0.0,15.3,17.98,0.0,3441; 3493,57.82,58.5,14.11,
      13.83,14.22,17.92,1984.49,3.79,0.0,15.28,17.94,0.0,3463];
  // Measured data for step response with a volume flow of 2000 m^3/h in the air canal;

  parameter Real AC_3000[:,:]=[0,45.71,38.9,14.95,14.71,15.09,16.16,2990.91,
      3.86,0.0,15.02,15.51,0.0,3392; 10,45.67,38.8,14.93,14.68,15.08,16.15,
      3012.55,3.86,0.0,15.01,15.51,0.0,3398; 20,45.63,38.8,14.93,14.67,15.07,
      16.14,2974.06,3.92,0.0,15.02,15.48,0.0,3412; 30,45.6,38.7,14.9,14.66,
      15.06,16.12,2962.3,3.88,0.0,14.98,15.46,0.0,3376; 40,45.57,38.7,14.87,
      14.63,15.05,16.1,3012.84,3.84,0.0,14.98,15.44,0.0,3382; 50,45.51,38.6,
      14.86,14.62,15.05,16.09,2970.48,3.79,0.0,14.98,15.44,0.0,3376; 60,45.48,
      38.6,14.85,14.6,15.04,16.08,2987.57,3.85,0.0,14.96,15.41,0.0,3396; 70,
      45.44,38.5,14.84,14.59,15.03,16.07,3029.6,3.84,0.0,14.96,15.44,0.0,3386;
      80,45.42,38.5,14.83,14.59,15.02,16.06,3017.71,3.91,0.0,14.94,15.41,0.0,
      3383; 90,45.37,38.4,14.82,14.59,15.0,16.04,2933.71,3.86,0.0,14.93,15.39,
      4.32,3381; 100,45.33,38.4,14.82,14.57,14.99,16.03,3021.7,3.78,0.0,14.92,
      15.37,16.55,3389; 110,45.24,38.6,14.82,14.57,14.98,16.02,2982.48,3.74,
      0.03,14.92,15.35,24.03,3430; 120,43.73,41.4,14.84,14.55,14.96,16.0,
      3012.48,3.56,0.2,14.94,15.34,36.83,3517; 130,32.67,49.8,16.41,14.78,
      14.95,15.99,2978.6,3.21,0.54,15.35,15.44,48.2,3610; 140,18.42,64.5,
      19.23,15.52,14.95,16.01,3020.39,3.04,1.23,16.9,15.83,55.97,3649; 150,
      24.62,68.6,32.49,18.28,14.94,16.3,3033.61,2.96,1.96,21.5,17.25,69.06,
      3657; 160,38.55,69.9,48.94,26.32,14.94,16.96,2936.28,2.95,2.64,28.52,
      20.11,77.12,3652; 170,50.98,70.9,64.79,41.34,14.94,18.25,2972.93,3.08,
      3.0,35.92,24.11,89.06,3599; 180,57.83,72.0,67.31,45.79,14.96,20.92,
      2956.7,3.25,3.0,42.02,28.2,95.97,3568; 190,60.23,73.7,71.22,57.25,14.99,
      23.32,2983.47,3.24,3.0,46.47,31.52,100.0,3568; 200,61.8,75.6,73.4,60.63,
      15.01,25.76,2996.04,3.26,3.0,49.8,34.14,100.0,3570; 210,63.48,77.2,
      74.82,61.79,15.04,27.55,3018.63,3.26,3.0,52.57,36.38,100.0,3571; 220,
      64.97,78.1,76.99,63.83,15.08,31.27,2953.5,3.25,3.0,54.9,38.28,100.0,
      3566; 230,66.05,78.6,78.24,65.49,15.1,33.18,2976.43,3.21,3.0,56.71,
      39.95,100.0,3563; 240,66.61,78.7,78.63,66.16,15.12,34.91,3013.73,3.25,
      3.0,58.12,41.25,100.0,3566; 250,67.0,78.8,78.86,66.64,15.14,36.96,
      2979.6,3.26,3.0,59.18,42.29,100.0,3564; 260,67.11,78.9,79.1,67.13,15.15,
      38.58,2933.77,3.24,3.0,59.98,43.17,100.0,3563; 271,67.3,79.0,79.14,
      67.26,15.17,39.91,2978.53,3.26,3.0,60.55,43.96,100.0,3563; 280,67.35,
      79.0,79.22,67.38,15.19,40.87,2968.34,3.24,3.0,61.12,44.64,100.0,3566;
      290,67.45,79.0,79.3,67.48,15.2,41.73,3023.42,3.24,3.0,61.53,45.21,100.0,
      3562; 300,67.51,79.0,79.31,67.59,15.21,43.04,2935.63,3.23,3.0,61.83,
      45.7,100.0,3562; 310,67.54,79.0,79.3,67.59,15.22,43.38,2951.11,3.21,3.0,
      62.1,46.17,100.0,3562; 320,67.56,79.0,79.32,67.64,15.23,44.29,3040.96,
      3.22,3.0,62.35,46.61,100.0,3566; 330,67.59,79.0,79.38,67.66,15.24,45.18,
      2903.56,3.24,3.0,62.55,46.94,100.0,3563; 340,67.65,79.0,79.38,67.68,
      15.24,45.67,2927.44,3.25,3.0,62.73,47.22,100.0,3562; 350,67.66,78.9,
      79.34,67.73,15.25,46.35,3012.77,3.26,3.0,62.94,47.53,100.0,3564; 360,
      67.68,78.9,79.34,67.75,15.26,46.88,2969.14,3.22,3.0,63.07,47.78,100.0,
      3562; 370,67.63,78.9,79.29,67.76,15.27,47.26,2998.84,3.23,3.0,63.18,
      48.08,100.0,3565; 380,67.65,78.9,79.3,67.75,15.27,47.78,2962.42,3.21,
      3.0,63.31,48.35,100.0,3560; 391,67.7,78.9,79.33,67.74,15.27,48.29,
      3044.25,3.24,3.0,63.46,48.64,100.0,3560; 400,67.76,78.8,79.35,67.8,
      15.28,48.59,2950.92,3.23,3.0,63.59,48.76,100.0,3563; 411,67.68,78.8,
      79.27,67.81,15.27,48.74,2981.65,3.21,3.0,63.69,48.97,100.0,3563; 420,
      67.72,78.7,79.29,67.8,15.27,49.32,2932.38,3.23,3.0,63.76,49.19,100.0,
      3561; 430,67.68,78.7,79.22,67.81,15.27,49.61,2984.52,3.22,3.0,63.81,
      49.41,100.0,3564; 441,67.6,78.6,79.15,67.79,15.28,49.87,3030.87,3.24,
      3.0,63.85,49.62,100.0,3560; 450,67.54,78.3,79.03,67.7,15.29,50.17,
      2931.26,3.22,3.0,63.91,49.7,100.0,3561; 461,67.44,78.1,78.79,67.61,15.3,
      50.63,2986.46,3.21,3.0,63.87,49.89,100.0,3561; 470,67.23,77.7,78.63,
      67.52,15.3,50.84,2979.88,3.22,3.0,63.83,50.08,100.0,3558; 481,67.06,
      77.2,78.27,67.31,15.3,51.07,2965.69,3.25,3.0,63.77,50.22,100.0,3561;
      491,66.73,76.6,77.79,67.05,15.3,51.26,3039.62,3.23,3.0,63.64,50.34,
      100.0,3560; 501,66.23,75.9,77.32,66.81,15.3,51.43,3025.77,3.23,3.0,
      63.37,50.41,100.0,3565; 510,65.75,75.5,76.69,66.32,15.29,51.53,2989.29,
      3.23,3.0,63.1,50.45,100.0,3563; 520,65.34,75.2,76.21,65.86,15.29,51.66,
      3031.55,3.23,3.0,62.83,50.36,100.0,3559; 531,65.02,75.1,75.79,65.37,
      15.29,51.74,2959.65,3.22,3.0,62.58,50.35,100.0,3560; 541,64.91,75.2,
      75.66,65.08,15.29,51.84,3031.49,3.21,3.0,62.44,50.36,100.0,3559; 551,
      64.92,75.4,75.68,65.0,15.29,51.88,2980.72,3.21,3.0,62.39,50.38,100.0,
      3562; 560,65.01,75.5,75.82,65.01,15.29,51.95,3000.39,3.23,3.0,62.39,
      50.41,100.0,3554; 571,65.15,75.7,75.94,65.08,15.29,52.04,2988.76,3.23,
      3.0,62.44,50.5,100.0,3557; 581,65.27,75.9,76.14,65.22,15.29,52.13,
      2997.2,3.24,3.0,62.55,50.61,100.0,3561; 591,65.46,76.0,76.38,65.4,15.29,
      52.24,3007.62,3.24,3.0,62.68,50.75,100.0,3560; 601,65.56,76.2,76.48,
      65.53,15.29,52.33,3008.49,3.23,3.0,62.82,50.95,100.0,3560; 611,65.69,
      76.3,76.57,65.63,15.28,52.47,3044.56,3.23,3.0,62.99,51.11,100.0,3559;
      621,65.79,76.4,76.76,65.79,15.27,52.62,2987.43,3.23,3.0,63.12,51.27,
      100.0,3560; 631,65.84,76.5,76.82,65.86,15.26,52.75,2998.16,3.23,3.0,
      63.21,51.42,100.0,3556; 640,65.92,76.5,76.93,65.94,15.26,52.87,2941.21,
      3.24,3.0,63.33,51.54,100.0,3561; 651,65.97,76.5,76.95,66.02,15.25,53.01,
      3018.13,3.22,3.0,63.39,51.69,100.0,3565; 661,65.97,76.5,76.96,66.04,
      15.25,53.13,3057.37,3.23,3.0,63.53,51.82,100.0,3562; 671,65.98,76.5,
      76.97,66.04,15.25,53.25,2978.34,3.25,3.0,63.56,51.98,100.0,3561; 680,
      65.95,76.4,76.94,66.06,15.24,53.32,2982.71,3.21,3.0,63.58,52.14,100.0,
      3566; 691,66.0,76.4,76.94,66.05,15.25,53.51,2995.08,3.23,3.0,63.59,
      52.25,100.0,3562; 701,65.96,76.4,76.93,66.06,15.26,53.65,2994.15,3.2,
      3.0,63.67,52.35,100.0,3563; 711,65.98,76.5,76.94,66.07,15.26,53.72,
      3024.75,3.21,3.0,63.72,52.43,100.0,3560; 721,66.0,76.5,76.96,66.08,
      15.25,53.82,2980.81,3.21,3.0,63.77,52.53,100.0,3563; 730,66.03,76.5,
      76.97,66.08,15.26,53.96,3011.04,3.25,3.0,63.81,52.64,100.0,3560; 741,
      66.02,76.4,76.96,66.1,15.26,54.0,2997.26,3.21,3.0,63.86,52.74,100.0,
      3561; 751,66.0,76.3,76.88,66.08,15.26,54.14,3011.39,3.22,3.0,63.86,
      52.82,100.0,3562; 761,65.92,76.1,76.82,66.07,15.27,54.23,3012.71,3.24,
      3.0,63.86,52.91,100.0,3560; 770,65.86,75.9,76.69,66.01,15.27,54.29,
      2917.8,3.2,3.0,63.88,52.97,100.0,3556; 781,65.69,75.7,76.52,65.92,15.27,
      54.37,2983.37,3.19,3.0,63.85,53.06,100.0,3559; 791,65.53,75.5,76.21,
      65.75,15.26,54.44,3025.56,3.24,3.0,63.74,53.1,100.0,3563; 801,65.32,
      75.3,76.13,65.64,15.25,54.48,2969.71,3.23,3.0,63.65,53.16,100.0,3562;
      811,65.19,75.2,75.87,65.4,15.26,54.53,3000.3,3.24,3.0,63.55,53.13,100.0,
      3559; 820,65.07,75.2,75.73,65.23,15.26,54.56,3013.67,3.24,3.0,63.46,
      53.17,100.0,3562; 831,65.03,75.2,75.69,65.16,15.27,54.58,3009.35,3.23,
      3.0,63.44,53.17,100.0,3555; 841,65.01,75.3,75.7,65.09,15.26,54.6,
      3032.99,3.2,3.0,63.41,53.17,100.0,3559; 851,65.05,75.3,75.76,65.1,15.26,
      54.63,2965.88,3.22,3.0,63.36,53.25,100.0,3556; 861,65.08,75.4,75.81,
      65.1,15.26,54.64,2972.83,3.22,3.0,63.39,53.33,100.0,3560; 871,65.15,
      75.4,75.84,65.19,15.26,54.68,2986.92,3.27,3.0,63.44,53.4,100.0,3556;
      881,65.19,75.5,75.92,65.23,15.26,54.72,2958.57,3.21,3.0,63.49,53.45,
      100.0,3559; 891,65.23,75.5,75.95,65.25,15.26,54.75,2981.62,3.22,3.0,
      63.53,53.46,100.0,3560; 901,65.26,75.5,75.99,65.3,15.26,54.83,3020.41,
      3.2,3.0,63.56,53.53,100.0,3561; 911,65.29,75.4,76.02,65.33,15.26,54.88,
      2981.73,3.22,3.0,63.61,53.59,100.0,3556; 921,65.27,75.2,75.97,65.36,
      15.26,54.91,2992.37,3.24,3.0,63.65,53.64,100.0,3563; 931,65.12,75.2,
      75.83,65.35,15.25,54.96,3005.23,3.21,3.0,63.67,53.75,100.0,3562; 941,
      65.07,75.4,75.75,65.21,15.24,54.98,3031.11,3.2,3.0,63.64,53.82,100.0,
      3559; 951,65.15,75.6,75.86,65.16,15.24,55.01,2980.2,3.24,3.0,63.69,
      53.85,100.0,3559; 961,65.27,75.8,75.99,65.21,15.24,55.04,2964.33,3.22,
      3.0,63.71,53.89,100.0,3563; 971,65.41,75.9,76.11,65.28,15.24,55.08,
      2980.99,3.21,3.0,63.82,53.95,100.0,3563; 981,65.57,76.0,76.39,65.54,
      15.24,55.1,2990.05,3.21,3.0,63.94,54.09,100.0,3565; 991,65.69,76.1,76.5,
      65.65,15.24,55.19,2949.64,3.21,3.0,64.06,54.14,100.0,3558; 1001,65.74,
      76.1,76.54,65.77,15.24,55.25,2994.87,3.22,3.0,64.11,54.29,100.0,3563;
      1011,65.76,76.2,76.63,65.81,15.24,55.32,2988.38,3.22,3.0,64.19,54.39,
      100.0,3562; 1021,65.82,76.2,76.66,65.87,15.24,55.4,2976.61,3.21,3.0,
      64.29,54.5,100.0,3559; 1031,65.81,76.1,76.67,65.89,15.24,55.47,2939.41,
      3.2,3.0,64.34,54.53,100.0,3566; 1041,65.86,76.1,76.66,65.92,15.24,55.52,
      3019.7,3.2,3.0,64.36,54.56,100.0,3555; 1051,65.85,76.1,76.66,65.93,
      15.24,55.6,2977.86,3.2,3.0,64.37,54.62,100.0,3556; 1061,65.79,76.0,
      76.63,65.93,15.25,55.68,2977.93,3.24,3.0,64.38,54.68,100.0,3556; 1071,
      65.74,75.9,76.53,65.86,15.25,55.73,2987.12,3.22,3.0,64.4,54.73,100.0,
      3562; 1081,65.64,75.8,76.41,65.8,15.24,55.79,2975.84,3.21,3.0,64.32,
      54.8,100.0,3561; 1091,65.57,75.8,76.34,65.71,15.24,55.84,3006.38,3.18,
      3.0,64.34,54.83,100.0,3559; 1101,65.56,75.9,76.3,65.66,15.24,55.88,
      3000.18,3.2,3.0,64.29,54.87,100.0,3562; 1111,65.57,75.9,76.36,65.64,
      15.24,55.9,2956.9,3.21,3.0,64.27,54.89,100.0,3557; 1121,65.62,76.0,
      76.39,65.65,15.24,55.93,2984.65,3.21,3.0,64.3,54.94,100.0,3563; 1131,
      65.69,76.1,76.48,65.7,15.24,55.96,3017.97,3.21,3.0,64.37,54.93,100.0,
      3562; 1141,65.73,76.1,76.52,65.77,15.24,56.01,2965.49,3.21,3.0,64.4,
      55.0,100.0,3565; 1151,65.76,76.1,76.55,65.79,15.24,56.02,3014.96,3.21,
      3.0,64.43,55.05,100.0,3555; 1161,65.81,76.2,76.61,65.82,15.22,56.06,
      2978.17,3.22,3.0,64.48,55.12,100.0,3561; 1171,65.81,76.2,76.66,65.91,
      15.22,56.12,3009.66,3.2,3.0,64.53,55.17,100.0,3562; 1181,65.86,76.2,
      76.67,65.91,15.22,56.18,3027.24,3.19,3.0,64.57,55.22,100.0,3561; 1191,
      65.86,76.2,76.66,65.94,15.22,56.22,2993.69,3.21,3.0,64.58,55.27,100.0,
      3560; 1201,65.89,76.1,76.66,65.93,15.22,56.25,3022.54,3.22,3.0,64.64,
      55.31,100.0,3560; 1211,65.84,76.1,76.66,65.94,15.22,56.29,3029.89,3.2,
      3.0,64.64,55.33,100.0,3558; 1221,65.81,76.1,76.59,65.92,15.21,56.34,
      3022.76,3.19,3.0,64.64,55.37,100.0,3559; 1231,65.8,76.1,76.6,65.89,15.2,
      56.37,2987.79,3.2,3.0,64.65,55.43,100.0,3560; 1241,65.86,76.2,76.65,
      65.9,15.2,56.41,2991.25,3.23,3.0,64.71,55.48,100.0,3560; 1251,65.89,
      76.2,76.66,65.93,15.2,56.42,2965.11,3.22,3.0,64.71,55.5,100.0,3564;
      1261,65.9,76.3,76.68,65.97,15.19,56.47,3042.09,3.24,3.0,64.78,55.54,
      100.0,3564; 1271,65.92,76.3,76.78,66.0,15.19,56.5,2996.78,3.2,3.0,64.76,
      55.54,100.0,3565; 1281,65.98,76.4,76.82,66.03,15.2,56.57,3007.74,3.21,
      3.0,64.76,55.62,100.0,3565; 1291,66.05,76.5,76.87,66.07,15.22,56.6,
      3004.98,3.24,3.0,64.84,55.66,100.0,3566; 1301,66.09,76.5,76.94,66.15,
      15.23,56.65,2980.7,3.21,3.0,64.91,55.73,100.0,3560; 1311,66.12,76.5,
      76.96,66.2,15.22,56.67,2992.79,3.21,3.0,64.93,55.81,100.0,3566; 1321,
      66.14,76.5,76.96,66.2,15.22,56.71,3000.38,3.21,3.0,64.97,55.87,100.0,
      3566; 1331,66.17,76.5,77.05,66.23,15.22,56.77,2996.82,3.21,3.0,65.0,
      55.88,100.0,3562; 1341,66.19,76.5,77.05,66.25,15.22,56.79,2989.43,3.21,
      3.0,65.01,55.95,100.0,3564; 1351,66.21,76.5,77.04,66.28,15.22,56.84,
      3017.12,3.21,3.0,65.12,56.03,100.0,3561; 1361,66.19,76.5,77.02,66.29,
      15.21,56.87,2992.22,3.19,3.0,65.1,56.05,100.0,3560; 1371,66.14,76.5,
      76.99,66.25,15.21,56.89,3001.48,3.21,3.0,65.12,56.04,100.0,3564; 1381,
      66.16,76.5,76.98,66.25,15.2,56.94,2996.33,3.2,3.0,65.08,56.1,100.0,3549;
      1391,66.16,76.5,77.02,66.23,15.21,56.98,2987.58,3.22,3.0,65.07,56.13,
      100.0,3554; 1401,66.19,76.6,77.05,66.24,15.21,57.01,2949.21,3.2,3.0,
      65.17,56.15,100.0,3557; 1411,66.24,76.6,77.05,66.27,15.21,57.05,3044.11,
      3.22,3.0,65.17,56.16,100.0,3558; 1421,66.21,76.6,77.08,66.31,15.21,
      57.08,2994.16,3.2,3.0,65.17,56.2,100.0,3560; 1431,66.29,76.6,77.11,
      66.33,15.21,57.11,3040.7,3.2,3.0,65.2,56.27,100.0,3559; 1442,66.28,76.7,
      77.16,66.35,15.2,57.14,3018.35,3.22,3.0,65.24,56.35,100.0,3562; 1451,
      66.35,76.7,77.18,66.35,15.2,57.18,2981.79,3.22,3.0,65.29,56.35,100.0,
      3560; 1462,66.37,76.7,77.22,66.45,15.2,57.22,3017.96,3.22,3.0,65.34,
      56.35,100.0,3561; 1471,66.4,76.7,77.23,66.47,15.2,57.24,3011.18,3.19,
      3.0,65.39,56.37,100.0,3560; 1481,66.39,76.7,77.22,66.47,15.2,57.27,
      3030.1,3.23,3.0,65.41,56.46,100.0,3563; 1491,66.4,76.7,77.23,66.46,
      15.19,57.29,3027.89,3.21,3.0,65.41,56.52,100.0,3558; 1501,66.39,76.8,
      77.24,66.47,15.19,57.31,2976.31,3.2,3.0,65.45,56.54,100.0,3559; 1511,
      66.4,76.8,77.24,66.48,15.18,57.34,3016.08,3.21,3.0,65.45,56.54,100.0,
      3557; 1521,66.4,76.8,77.25,66.48,15.18,57.35,3011.75,3.21,3.0,65.46,
      56.57,100.0,3559; 1532,66.41,76.8,77.27,66.48,15.18,57.39,3024.09,3.23,
      3.0,65.45,56.6,100.0,3560; 1541,66.45,76.9,77.32,66.49,15.18,57.41,
      2998.55,3.2,3.0,65.46,56.65,100.0,3560; 1551,66.47,76.9,77.35,66.51,
      15.18,57.46,2998.83,3.2,3.0,65.5,56.68,100.0,3557; 1561,66.47,76.9,
      77.36,66.54,15.18,57.51,2989.87,3.18,3.0,65.52,56.7,100.0,3561; 1571,
      66.51,77.0,77.37,66.58,15.18,57.53,2986.64,3.22,3.0,65.57,56.69,100.0,
      3561; 1581,66.56,77.0,77.43,66.59,15.18,57.56,2996.42,3.23,3.0,65.58,
      56.77,100.0,3559; 1591,66.58,77.0,77.5,66.63,15.18,57.6,2970.99,3.21,
      3.0,65.62,56.84,100.0,3561; 1602,66.61,77.1,77.5,66.68,15.18,57.62,
      2961.12,3.19,3.0,65.62,56.87,100.0,3561; 1611,66.64,77.1,77.54,66.7,
      15.19,57.66,2993.44,3.23,3.0,65.66,56.91,100.0,3560; 1621,66.67,77.1,
      77.58,66.74,15.19,57.69,2996.22,3.2,3.0,65.67,56.96,100.0,3556; 1631,
      66.69,77.1,77.62,66.75,15.2,57.73,3017.55,3.22,3.0,65.69,57.01,100.0,
      3558; 1641,66.71,77.1,77.63,66.76,15.2,57.75,3030.73,3.22,3.0,65.75,
      57.05,100.0,3560; 1652,66.75,77.2,77.64,66.78,15.19,57.8,2953.83,3.22,
      3.0,65.79,57.07,100.0,3557; 1661,66.73,77.2,77.64,66.84,15.18,57.84,
      3020.01,3.2,3.0,65.82,57.08,100.0,3559; 1672,66.76,77.3,77.67,66.82,
      15.17,57.88,3003.49,3.2,3.0,65.82,57.08,100.0,3556; 1681,66.78,77.3,
      77.68,66.82,15.17,57.92,2982.33,3.2,3.0,65.86,57.14,100.0,3560; 1691,
      66.85,77.3,77.78,66.91,15.18,57.94,2996.58,3.19,3.0,65.88,57.19,100.0,
      3558; 1702,66.88,77.3,77.79,66.93,15.18,57.98,3000.62,3.24,3.0,65.91,
      57.21,100.0,3557; 1711,66.89,77.4,77.81,66.93,15.19,58.0,2970.42,3.23,
      3.0,65.94,57.21,100.0,3559; 1722,66.91,77.4,77.85,66.95,15.18,58.04,
      2959.69,3.19,3.0,65.99,57.28,100.0,3562; 1731,66.94,77.4,77.9,67.01,
      15.17,58.08,2962.22,3.19,3.0,66.02,57.34,100.0,3563; 1742,66.97,77.4,
      77.92,67.03,15.17,58.11,2993.54,3.21,3.0,66.01,57.41,100.0,3556; 1752,
      67.0,77.5,77.93,67.04,15.18,58.12,3013.04,3.23,3.0,66.04,57.46,100.0,
      3559; 1761,66.95,77.5,77.93,67.05,15.18,58.16,3008.12,3.21,3.0,66.12,
      57.51,100.0,3559; 1771,67.0,77.5,77.95,67.05,15.17,58.2,2980.71,3.21,
      3.0,66.16,57.47,100.0,3559; 1781,67.02,77.5,77.93,67.07,15.17,58.25,
      2984.48,3.22,3.0,66.16,57.45,100.0,3559; 1792,67.01,77.5,77.96,67.12,
      15.18,58.28,2994.51,3.21,3.0,66.17,57.47,100.0,3559; 1802,67.04,77.5,
      77.95,67.1,15.17,58.31,3004.95,3.21,3.0,66.19,57.51,100.0,3558; 1812,
      67.05,77.5,77.96,67.09,15.17,58.33,2976.13,3.22,3.0,66.12,57.51,100.0,
      3560; 1821,67.06,77.6,78.03,67.13,15.18,58.36,2999.92,3.22,3.0,66.12,
      57.57,100.0,3561; 1831,67.1,77.6,78.05,67.16,15.2,58.37,3006.09,3.2,3.0,
      66.16,57.62,100.0,3557; 1842,67.13,77.7,78.07,67.16,15.2,58.4,3018.85,
      3.2,3.0,66.19,57.65,100.0,3561; 1852,67.13,77.7,78.13,67.2,15.19,58.43,
      2981.64,3.21,3.0,66.21,57.64,100.0,3560; 1862,67.13,77.7,78.13,67.2,
      15.19,58.45,3029.36,3.2,3.0,66.26,57.69,100.0,3559; 1872,67.16,77.7,
      78.19,67.22,15.19,58.46,2979.39,3.2,3.0,66.26,57.7,100.0,3552; 1882,
      67.23,77.8,78.2,67.24,15.19,58.48,3021.5,3.21,3.0,66.33,57.69,100.0,
      3556; 1892,67.25,77.8,78.26,67.3,15.18,58.52,3022.53,3.22,3.0,66.34,
      57.73,100.0,3556; 1901,67.26,77.8,78.31,67.32,15.18,58.56,3013.49,3.19,
      3.0,66.4,57.78,100.0,3554; 1912,67.32,77.9,78.33,67.34,15.18,58.58,
      2992.9,3.21,3.0,66.43,57.83,100.0,3560; 1922,67.33,77.9,78.35,67.38,
      15.17,58.62,3048.83,3.2,3.0,66.46,57.85,100.0,3559; 1932,67.35,77.9,
      78.38,67.43,15.17,58.67,3037.99,3.21,3.0,66.5,57.87,100.0,3555; 1941,
      67.35,78.0,78.39,67.43,15.17,58.68,2960.83,3.19,3.0,66.56,57.94,100.0,
      3558; 1952,67.45,78.0,78.46,67.47,15.17,58.74,3015.45,3.19,3.0,66.59,
      57.99,100.0,3556; 1962,67.41,78.0,78.48,67.5,15.17,58.77,2963.61,3.2,
      3.0,66.57,58.0,100.0,3557; 1972,67.46,78.1,78.49,67.48,15.17,58.8,
      3012.99,3.18,3.0,66.61,58.05,100.0,3559; 1982,67.47,78.1,78.57,67.53,
      15.18,58.84,2984.74,3.2,3.0,66.6,58.08,100.0,3560; 1991,67.47,78.2,
      78.57,67.57,15.18,58.88,2955.87,3.2,3.0,66.62,58.11,100.0,3563; 2002,
      67.56,78.2,78.62,67.57,15.19,58.91,3036.73,3.2,3.0,66.66,58.13,100.0,
      3558; 2012,67.59,78.2,78.64,67.61,15.19,58.93,3009.79,3.21,3.0,66.7,
      58.14,100.0,3551; 2022,67.59,78.2,78.71,67.66,15.18,58.98,3003.77,3.22,
      3.0,66.73,58.14,100.0,3556; 2031,67.61,78.2,78.73,67.66,15.17,58.99,
      3000.49,3.2,3.0,66.81,58.16,100.0,3559; 2041,67.65,78.3,78.74,67.7,
      15.18,59.0,3007.6,3.19,3.0,66.82,58.17,100.0,3556; 2052,67.65,78.3,
      78.76,67.71,15.19,59.03,3012.48,3.2,3.0,66.83,58.18,100.0,3559; 2062,
      67.68,78.3,78.76,67.72,15.19,59.04,3008.97,3.22,3.0,66.83,58.25,100.0,
      3560; 2072,67.68,78.3,78.77,67.75,15.2,59.07,2965.21,3.23,3.0,66.89,
      58.3,100.0,3560; 2081,67.73,78.3,78.78,67.78,15.19,59.11,2996.63,3.21,
      3.0,66.94,58.28,100.0,3553; 2092,67.7,78.3,78.77,67.8,15.19,59.15,
      3044.43,3.19,3.0,66.9,58.28,100.0,3560; 2102,67.67,78.3,78.77,67.77,
      15.18,59.17,2974.7,3.19,3.0,66.88,58.31,100.0,3558; 2112,67.72,78.3,
      78.79,67.77,15.18,59.17,3004.82,3.19,3.0,66.93,58.33,100.0,3559; 2122,
      67.71,78.3,78.81,67.8,15.19,59.19,3004.16,3.19,3.0,66.95,58.38,100.0,
      3558; 2132,67.73,78.3,78.81,67.82,15.18,59.21,3023.74,3.2,3.0,66.9,
      58.42,100.0,3555; 2142,67.72,78.3,78.81,67.82,15.19,59.23,3027.91,3.18,
      3.0,66.92,58.42,100.0,3560; 2152,67.73,78.3,78.8,67.82,15.2,59.26,
      3030.78,3.19,3.0,66.94,58.41,100.0,3560; 2162,67.76,78.4,78.83,67.81,
      15.19,59.28,3015.75,3.19,3.0,66.99,58.42,100.0,3560; 2172,67.73,78.4,
      78.81,67.83,15.18,59.29,2972.37,3.21,3.0,67.0,58.47,100.0,3558; 2182,
      67.79,78.4,78.89,67.85,15.18,59.29,3004.49,3.19,3.0,67.01,58.49,100.0,
      3557; 2192,67.77,78.4,78.89,67.86,15.18,59.34,3027.47,3.21,3.0,67.03,
      58.49,100.0,3559; 2202,67.79,78.4,78.9,67.86,15.18,59.36,2980.62,3.21,
      3.0,67.04,58.54,100.0,3556; 2212,67.79,78.4,78.91,67.89,15.18,59.39,
      2974.93,3.22,3.0,67.05,58.61,100.0,3561; 2222,67.84,78.5,78.92,67.9,
      15.19,59.41,2985.97,3.21,3.0,67.06,58.65,100.0,3557; 2232,67.82,78.5,
      78.94,67.92,15.2,59.44,2998.34,3.22,3.0,67.05,58.66,100.0,3552; 2242,
      67.87,78.5,78.98,67.94,15.2,59.45,3029.68,3.2,3.0,67.1,58.69,100.0,3554;
      2252,67.92,78.5,79.02,67.97,15.19,59.47,2999.65,3.22,3.0,67.13,58.66,
      100.0,3558; 2262,67.89,78.6,79.02,67.99,15.19,59.5,3008.01,3.2,3.0,
      67.15,58.72,100.0,3554; 2272,67.91,78.6,79.04,67.99,15.19,59.52,3031.84,
      3.19,3.0,67.14,58.71,100.0,3549; 2282,67.92,78.6,79.06,67.99,15.19,
      59.55,3010.75,3.19,3.0,67.11,58.75,100.0,3551; 2292,67.95,78.6,79.09,
      68.01,15.18,59.57,3007.18,3.22,3.0,67.15,58.78,100.0,3552; 2302,68.02,
      78.6,79.12,68.02,15.19,59.59,3064.37,3.19,3.0,67.19,58.82,100.0,3556;
      2312,68.0,78.7,79.15,68.07,15.19,59.6,2994.45,3.2,3.0,67.25,58.77,100.0,
      3553; 2322,68.04,78.7,79.17,68.07,15.19,59.62,3005.93,3.22,3.0,67.26,
      58.8,100.0,3556; 2332,68.04,78.7,79.18,68.12,15.19,59.66,2993.87,3.2,
      3.0,67.25,58.82,100.0,3557; 2342,68.05,78.8,79.18,68.12,15.2,59.68,
      2973.53,3.19,3.0,67.3,58.85,100.0,3551; 2352,68.09,78.7,79.22,68.14,
      15.2,59.69,3006.83,3.21,3.0,67.32,58.87,100.0,3555; 2362,68.07,78.8,
      79.21,68.16,15.2,59.7,3032.96,3.17,3.0,67.32,58.92,100.0,3555; 2372,
      68.07,78.8,79.23,68.15,15.19,59.72,2973.9,3.21,3.0,67.32,58.91,100.0,
      3554; 2382,68.12,78.8,79.29,68.15,15.18,59.75,2973.68,3.18,3.0,67.38,
      58.94,100.0,3556; 2392,68.14,78.8,79.3,68.21,15.18,59.76,2982.01,3.19,
      3.0,67.41,58.96,100.0,3553; 2402,68.12,78.8,79.31,68.22,15.17,59.79,
      3000.1,3.22,3.0,67.43,59.0,100.0,3551; 2412,68.15,78.8,79.32,68.19,
      15.17,59.8,3009.42,3.19,3.0,67.44,59.05,100.0,3555; 2422,68.17,78.9,
      79.32,68.25,15.17,59.81,2974.3,3.19,3.0,67.47,59.06,100.0,3553; 2432,
      68.18,78.9,79.32,68.26,15.17,59.83,3003.97,3.2,3.0,67.5,59.06,100.0,
      3551; 2442,68.22,78.9,79.36,68.28,15.17,59.86,3002.5,3.22,3.0,67.5,
      59.07,100.0,3549; 2452,68.23,79.0,79.39,68.3,15.16,59.88,2991.16,3.2,
      3.0,67.53,59.09,100.0,3551; 2462,68.26,79.0,79.43,68.3,15.16,59.9,
      2984.75,3.22,3.0,67.57,59.11,100.0,3552; 2472,68.27,79.0,79.48,68.33,
      15.16,59.92,2992.3,3.2,3.0,67.57,59.16,100.0,3554; 2482,68.31,79.1,79.5,
      68.38,15.16,59.94,3009.39,3.2,3.0,67.58,59.18,100.0,3555; 2492,68.33,
      79.1,79.57,68.41,15.16,59.98,2995.15,3.18,3.0,67.6,59.22,100.0,3555;
      2502,68.42,79.2,79.59,68.43,15.16,60.01,3000.7,3.2,3.0,67.61,59.25,
      100.0,3551; 2512,68.39,79.2,79.64,68.48,15.16,60.03,3044.83,3.2,3.0,
      67.65,59.28,100.0,3556; 2522,68.46,79.2,79.65,68.49,15.18,60.07,2982.06,
      3.21,3.0,67.68,59.32,100.0,3555; 2532,68.49,79.2,79.65,68.51,15.19,
      60.08,2986.07,3.19,3.0,67.7,59.36,100.0,3555; 2542,68.5,79.3,79.74,
      68.56,15.19,60.09,2952.7,3.17,3.0,67.73,59.36,100.0,3553; 2552,68.54,
      79.3,79.74,68.59,15.19,60.12,3020.24,3.2,3.0,67.79,59.41,100.0,3544;
      2562,68.51,79.3,79.75,68.6,15.19,60.13,3030.44,3.19,3.0,67.8,59.39,
      100.0,3550; 2572,68.54,79.3,79.78,68.6,15.18,60.15,3014.69,3.2,3.0,
      67.79,59.41,100.0,3553; 2583,68.55,79.3,79.76,68.61,15.18,60.19,2979.59,
      3.18,3.0,67.82,59.42,100.0,3551; 2592,68.55,79.4,79.76,68.6,15.19,60.22,
      3004.39,3.22,3.0,67.84,59.48,100.0,3551; 2602,68.59,79.3,79.84,68.63,
      15.19,60.23,3025.57,3.21,3.0,67.87,59.51,100.0,3551; 2612,68.61,79.4,
      79.84,68.66,15.19,60.25,2985.59,3.2,3.0,67.89,59.53,100.0,3554; 2622,
      68.61,79.4,79.85,68.7,15.19,60.28,2965.17,3.2,3.0,67.89,59.55,100.0,
      3555; 2632,68.61,79.4,79.87,68.69,15.19,60.3,2989.13,3.21,3.0,67.92,
      59.55,100.0,3549; 2642,68.64,79.4,79.88,68.69,15.18,60.33,3020.92,3.2,
      3.0,67.91,59.6,100.0,3552; 2652,68.64,79.5,79.9,68.72,15.19,60.35,
      3009.08,3.2,3.0,67.94,59.61,100.0,3553; 2662,68.69,79.5,79.92,68.72,
      15.19,60.36,3027.41,3.17,3.0,67.97,59.66,100.0,3550; 2672,68.7,79.5,
      79.96,68.75,15.19,60.38,2990.02,3.2,3.0,67.99,59.66,100.0,3552; 2682,
      68.73,79.5,79.97,68.76,15.2,60.39,2993.23,3.18,3.0,67.98,59.67,100.0,
      3554; 2692,68.71,79.5,79.97,68.8,15.19,60.42,3014.95,3.19,3.0,68.02,
      59.67,100.0,3553; 2702,68.75,79.5,79.99,68.79,15.19,60.45,3024.02,3.19,
      3.0,68.03,59.66,100.0,3551; 2712,68.72,79.5,80.02,68.82,15.2,60.47,
      2987.35,3.19,3.0,68.03,59.66,100.0,3555; 2723,68.75,79.5,80.02,68.81,
      15.19,60.48,2999.25,3.19,3.0,68.09,59.66,100.0,3550; 2732,68.76,79.6,
      80.02,68.83,15.19,60.5,3000.97,3.21,3.0,68.09,59.66,100.0,3552; 2742,
      68.76,79.6,80.04,68.84,15.19,60.52,3028.55,3.22,3.0,68.08,59.67,100.0,
      3556; 2752,68.77,79.6,80.06,68.84,15.19,60.54,2979.24,3.19,3.0,68.07,
      59.71,100.0,3555; 2762,68.81,79.6,80.09,68.86,15.2,60.57,3016.79,3.22,
      3.0,68.08,59.76,100.0,3549; 2773,68.81,79.7,80.12,68.87,15.2,60.59,
      2983.15,3.2,3.0,68.1,59.77,100.0,3553; 2782,68.83,79.7,80.16,68.87,15.2,
      60.62,2982.9,3.2,3.0,68.15,59.81,100.0,3554; 2793,68.89,79.7,80.16,
      68.91,15.19,60.63,3016.59,3.17,3.0,68.19,59.83,100.0,3550; 2802,68.88,
      79.7,80.18,68.95,15.19,60.65,3013.25,3.19,3.0,68.19,59.87,100.0,3553;
      2812,68.88,79.8,80.19,68.96,15.19,60.67,2993.57,3.19,3.0,68.23,59.89,
      100.0,3550; 2822,68.88,79.8,80.2,68.96,15.19,60.69,2992.37,3.2,3.0,
      68.23,59.95,100.0,3551; 2832,68.91,79.8,80.26,68.98,15.19,60.71,3001.21,
      3.17,3.0,68.24,59.98,100.0,3547; 2843,68.93,79.8,80.27,69.0,15.18,60.74,
      2983.76,3.19,3.0,68.26,59.98,100.0,3546; 2853,68.93,79.8,80.29,69.01,
      15.18,60.75,2966.58,3.2,3.0,68.29,59.97,100.0,3550; 2863,68.91,79.8,
      80.26,69.01,15.18,60.76,2975.22,3.19,3.0,68.32,59.95,100.0,3552; 2873,
      68.94,79.8,80.27,69.0,15.18,60.8,2997.72,3.2,3.0,68.35,59.94,100.0,3549;
      2882,68.96,79.8,80.28,69.01,15.18,60.82,2982.42,3.19,3.0,68.32,59.95,
      100.0,3553; 2892,68.96,79.8,80.3,69.02,15.18,60.83,2995.73,3.2,3.0,
      68.32,59.98,100.0,3552; 2902,69.0,79.8,80.3,69.03,15.18,60.84,3001.26,
      3.17,3.0,68.36,60.02,100.0,3551; 2913,68.98,79.8,80.3,69.07,15.19,60.85,
      2970.79,3.19,3.0,68.39,60.0,100.0,3553; 2922,69.0,79.9,80.3,69.08,15.18,
      60.86,3008.36,3.18,3.0,68.41,60.05,100.0,3554; 2932,69.0,79.8,80.33,
      69.09,15.18,60.88,3009.31,3.2,3.0,68.36,60.0,100.0,3553; 2942,68.98,
      79.8,80.31,69.08,15.18,60.92,2898.63,3.18,3.0,68.36,60.02,100.0,3553;
      2952,69.03,79.9,80.32,69.07,15.19,60.95,3019.12,3.19,3.0,68.36,60.05,
      100.0,3549; 2963,69.03,79.9,80.32,69.1,15.19,60.96,3014.95,3.2,3.0,
      68.34,60.12,100.0,3551; 2972,69.03,79.8,80.34,69.12,15.19,60.98,2998.0,
      3.18,3.0,68.36,60.1,100.0,3551; 2983,68.98,79.8,80.32,69.11,15.19,60.99,
      2937.75,3.19,3.0,68.41,60.1,100.0,3553; 2992,69.0,79.8,80.3,69.08,15.18,
      60.99,3007.01,3.17,3.0,68.39,60.1,100.0,3548; 3003,68.94,79.8,80.3,
      69.06,15.17,60.99,3014.81,3.2,3.0,68.41,60.08,100.0,3548; 3013,68.98,
      79.8,80.3,69.03,15.17,61.0,2993.86,3.17,3.0,68.41,60.05,100.0,3550;
      3022,68.96,79.8,80.3,69.03,15.17,61.01,2998.08,3.19,3.0,68.41,60.07,
      100.0,3546; 3032,68.98,79.9,80.3,69.05,15.17,61.02,3030.37,3.19,3.0,
      68.39,60.1,100.0,3551; 3042,68.98,79.8,80.31,69.05,15.17,61.02,2975.57,
      3.18,3.0,68.42,60.08,100.0,3546; 3053,69.03,79.9,80.33,69.07,15.18,
      61.03,3026.26,3.18,3.0,68.41,60.14,100.0,3551; 3062,68.98,79.8,80.33,
      69.1,15.18,61.04,2989.73,3.2,3.0,68.42,60.14,100.0,3547; 3073,69.01,
      79.8,80.32,69.08,15.18,61.04,2998.58,3.2,3.0,68.46,60.14,100.0,3554;
      3082,69.05,79.9,80.33,69.09,15.17,61.04,2950.77,3.21,3.0,68.46,60.14,
      100.0,3550; 3092,69.03,79.9,80.34,69.13,15.17,61.05,2966.26,3.2,3.0,
      68.46,60.15,100.0,3548; 3103,69.06,79.9,80.36,69.12,15.17,61.06,3031.39,
      3.19,3.0,68.51,60.14,100.0,3549; 3112,69.08,79.9,80.37,69.14,15.16,
      61.06,3009.38,3.21,3.0,68.51,60.21,100.0,3551; 3123,69.08,79.9,80.37,
      69.15,15.17,61.08,3045.98,3.19,3.0,68.46,60.16,100.0,3553; 3132,69.03,
      79.9,80.39,69.13,15.17,61.1,3003.54,3.2,3.0,68.42,60.16,100.0,3556;
      3143,69.03,79.9,80.42,69.11,15.18,61.11,2988.3,3.19,3.0,68.46,60.19,
      100.0,3553; 3153,69.08,79.9,80.41,69.12,15.19,61.12,3001.99,3.19,3.0,
      68.46,60.19,100.0,3549; 3163,69.06,80.0,80.41,69.14,15.19,61.14,2948.86,
      3.22,3.0,68.51,60.23,100.0,3554; 3173,69.08,80.0,80.43,69.14,15.18,
      61.14,2941.3,3.17,3.0,68.53,60.25,100.0,3554; 3182,69.12,79.9,80.44,
      69.15,15.19,61.15,2998.57,3.18,3.0,68.53,60.28,100.0,3551; 3193,69.11,
      80.0,80.45,69.18,15.19,61.16,2990.66,3.17,3.0,68.53,60.3,100.0,3552;
      3203,69.14,80.0,80.46,69.16,15.18,61.16,3029.62,3.19,3.0,68.57,60.28,
      100.0,3549; 3213,69.15,80.0,80.47,69.17,15.18,61.17,3031.39,3.18,3.0,
      68.61,60.32,100.0,3551; 3223,69.14,80.0,80.49,69.21,15.19,61.19,2979.87,
      3.2,3.0,68.58,60.35,100.0,3554; 3232,69.15,80.0,80.49,69.22,15.19,61.2,
      2951.79,3.16,3.0,68.58,60.38,100.0,3550; 3243,69.14,80.0,80.48,69.21,
      15.19,61.21,3029.65,3.2,3.0,68.53,60.41,100.0,3552; 3253,69.14,80.0,
      80.51,69.21,15.19,61.22,3017.63,3.19,3.0,68.51,60.44,100.0,3549; 3263,
      69.14,80.0,80.48,69.22,15.19,61.23,2999.59,3.19,3.0,68.51,60.42,100.0,
      3552; 3273,69.11,80.0,80.49,69.2,15.2,61.25,3009.59,3.2,3.0,68.49,60.42,
      100.0,3555; 3283,69.14,80.0,80.51,69.2,15.2,61.27,2971.39,3.2,3.0,68.51,
      60.43,100.0,3554; 3293,69.14,80.0,80.48,69.22,15.19,61.29,2979.85,3.18,
      3.0,68.56,60.43,100.0,3556; 3303,69.14,80.1,80.53,69.21,15.18,61.29,
      2989.08,3.21,3.0,68.57,60.46,100.0,3554; 3313,69.17,80.1,80.54,69.21,
      15.18,61.29,2964.09,3.19,3.0,68.62,60.47,100.0,3552; 3323,69.2,80.2,
      80.57,69.23,15.18,61.29,3019.11,3.18,3.0,68.61,60.46,100.0,3555; 3333,
      69.2,80.2,80.59,69.27,15.19,61.29,3047.75,3.21,3.0,68.65,60.46,100.0,
      3553; 3343,69.24,80.2,80.64,69.28,15.19,61.3,2980.99,3.19,3.0,68.62,
      60.48,100.0,3552; 3353,69.25,80.2,80.66,69.29,15.2,61.31,3015.84,3.19,
      3.0,68.62,60.46,100.0,3555; 3363,69.27,80.3,80.7,69.32,15.2,61.33,
      3033.6,3.19,3.0,68.65,60.49,100.0,3552; 3373,69.36,80.3,80.72,69.37,
      15.2,61.34,3024.49,3.2,3.0,68.75,60.53,100.0,3556; 3383,69.32,80.2,
      80.72,69.42,15.2,61.38,2986.85,3.18,3.0,68.79,60.54,100.0,3555; 3393,
      69.32,80.2,80.72,69.4,15.19,61.39,2998.71,3.19,3.0,68.8,60.53,100.0,
      3555; 3403,69.32,80.2,80.7,69.4,15.2,61.41,3005.75,3.19,3.0,68.8,60.53,
      100.0,3556; 3413,69.27,80.2,80.71,69.4,15.19,61.43,2977.33,3.19,3.0,
      68.8,60.52,100.0,3554; 3423,69.31,80.2,80.68,69.37,15.19,61.43,2999.82,
      3.17,3.0,68.74,60.54,100.0,3554; 3433,69.26,80.2,80.65,69.37,15.19,
      61.44,2957.59,3.2,3.0,68.72,60.55,100.0,3553; 3443,69.26,80.2,80.66,
      69.34,15.18,61.45,3010.09,3.18,3.0,68.73,60.59,100.0,3551; 3453,69.27,
      80.2,80.66,69.34,15.19,61.45,3011.66,3.2,3.0,68.7,60.62,100.0,3555;
      3463,69.27,80.2,80.63,69.32,15.2,61.45,2999.44,3.18,3.0,68.68,60.62,
      100.0,3550; 3473,69.26,80.2,80.62,69.34,15.2,61.46,2973.94,3.17,3.0,
      68.67,60.59,100.0,3554; 3483,69.26,80.2,80.63,69.34,15.2,61.46,2957.46,
      3.17,3.0,68.74,60.59,100.0,3554; 3493,69.27,80.2,80.64,69.36,15.2,61.46,
      2981.79,3.18,3.0,68.75,60.59,100.0,3551; 3503,69.28,80.1,80.63,69.35,
      15.19,61.46,3016.24,3.18,3.0,68.76,60.62,100.0,3555; 3513,69.26,80.1,
      80.6,69.36,15.18,61.46,2998.94,3.17,3.0,68.76,60.64,100.0,3555; 3523,
      69.21,80.1,80.58,69.29,15.17,61.46,3025.14,3.19,3.0,68.79,60.64,100.0,
      3555; 3533,69.21,80.1,80.57,69.28,15.16,61.46,3023.93,3.2,3.0,68.81,
      60.6,100.0,3555; 3543,69.16,80.0,80.58,69.28,15.16,61.46,3009.62,3.17,
      3.0,68.73,60.6,100.0,3555; 3553,69.15,80.0,80.53,69.25,15.16,61.46,
      3005.36,3.21,3.0,68.72,60.58,100.0,3555; 3563,69.14,80.0,80.47,69.22,
      15.17,61.45,3031.53,3.19,3.0,68.73,60.55,100.0,3556; 3573,69.12,80.0,
      80.47,69.22,15.18,61.45,2981.93,3.18,3.0,68.69,60.53,100.0,3553; 3583,
      69.1,79.9,80.43,69.2,15.19,61.44,2976.3,3.17,3.0,68.64,60.5,100.0,3551;
      3593,69.08,79.9,80.43,69.16,15.19,61.42,3053.57,3.18,3.0,68.62,60.49,
      100.0,3554; 3603,69.05,79.9,80.43,69.14,15.2,61.42,3009.15,3.16,3.0,
      68.56,60.5,100.0,3553; 3613,69.05,79.9,80.42,69.12,15.2,61.42,3004.48,
      3.2,3.0,68.58,60.52,100.0,3553; 3623,69.05,79.9,80.4,69.13,15.2,61.42,
      3034.49,3.17,3.0,68.57,60.53,100.0,3552; 3633,69.03,79.9,80.38,69.12,
      15.2,61.42,3021.48,3.18,3.0,68.57,60.53,100.0,3556; 3643,69.03,79.9,
      80.4,69.11,15.19,61.42,2989.29,3.16,3.0,68.59,60.5,100.0,3553; 3653,
      69.06,79.9,80.4,69.1,15.19,61.43,3008.9,3.16,3.0,68.59,60.5,100.0,3554;
      3663,69.03,79.9,80.39,69.13,15.18,61.43,2985.45,3.18,3.0,68.58,60.57,
      100.0,3554; 3673,69.03,79.9,80.39,69.12,15.18,61.43,2954.32,3.17,3.0,
      68.59,60.55,100.0,3552; 3683,69.05,79.9,80.39,69.11,15.18,61.43,3015.29,
      3.16,3.0,68.61,60.58,100.0,3555; 3693,69.08,79.9,80.41,69.13,15.18,
      61.43,3022.02,3.18,3.0,68.58,60.57,100.0,3552; 3703,69.06,79.9,80.41,
      69.13,15.18,61.43,3001.67,3.18,3.0,68.54,60.59,100.0,3555; 3713,69.05,
      79.9,80.39,69.13,15.18,61.43,2970.23,3.18,3.0,68.58,60.6,96.55,3554;
      3723,69.05,79.9,80.39,69.12,15.18,61.43,2963.36,3.18,3.0,68.59,60.59,
      88.63,3555; 3733,68.88,79.9,80.41,69.11,15.18,61.43,2993.57,3.09,3.0,
      68.53,60.6,78.71,3601; 3743,68.34,79.8,80.39,69.0,15.18,61.43,3004.79,
      2.86,2.53,68.36,60.59,66.47,3643; 3753,67.74,79.8,78.63,68.24,15.18,
      61.43,2985.7,2.92,1.82,67.84,60.46,53.09,3642; 3763,66.66,79.8,76.56,
      67.52,15.18,61.43,2997.98,3.02,1.03,66.73,60.1,45.47,3617; 3773,65.82,
      79.7,72.36,65.66,15.18,61.43,2985.91,3.17,0.45,64.84,59.39,32.95,3518;
      3783,65.35,79.6,66.67,62.43,15.18,61.43,2979.93,3.44,0.15,62.3,58.35,
      23.74,3419; 3793,65.27,79.5,59.25,56.89,15.18,60.16,2985.31,3.63,0.03,
      59.32,56.93,13.81,3394; 3803,65.37,79.4,57.45,55.37,15.17,59.67,3043.39,
      3.89,0.0,56.11,55.28,3.88,3429; 3813,65.37,79.4,51.68,50.07,15.13,58.05,
      3014.6,3.95,0.0,52.95,53.5,0.0,3401; 3823,65.36,79.2,46.73,45.3,15.11,
      56.45,3055.74,3.97,0.0,49.89,51.67,0.0,3423; 3833,65.31,79.0,44.22,42.9,
      15.09,55.56,3055.0,3.97,0.0,47.07,49.89,0.0,3442; 3843,65.26,78.8,42.17,
      40.92,15.08,53.97,2994.31,3.97,0.0,44.43,48.15,0.0,3387; 3853,65.16,
      78.6,37.37,36.28,15.05,52.16,2984.46,3.97,0.0,42.0,46.52,0.0,3394; 3863,
      65.02,78.4,34.87,33.87,15.03,51.0,3041.48,3.97,0.0,39.86,44.99,0.0,3394;
      3873,64.87,78.2,33.52,32.59,15.0,48.55,3047.7,3.97,0.0,37.85,43.55,0.0,
      3396; 3883,64.77,78.0,30.78,29.94,14.97,46.8,3009.73,3.97,0.0,36.08,
      42.24,0.0,3400; 3893,64.68,77.7,29.61,28.81,14.95,45.72,3053.02,3.97,
      0.0,34.45,41.01,0.0,3388; 3903,64.53,77.6,28.16,27.37,14.92,44.09,
      3020.56,3.97,0.0,32.94,39.78,0.0,3398; 3913,64.41,77.3,26.34,25.67,14.9,
      42.56,3054.24,3.97,0.0,31.59,38.66,0.0,3442; 3923,64.32,77.2,25.51,
      24.87,14.88,41.14,3005.57,3.97,0.0,30.4,37.58,0.0,3442; 3933,64.24,77.0,
      24.77,24.16,14.85,39.8,3064.05,3.97,0.0,29.31,36.58,0.0,3437; 3943,
      64.11,76.8,23.58,23.04,14.85,39.22,3015.21,3.97,0.0,28.29,35.62,0.0,
      3428; 3953,64.01,76.6,22.56,22.03,14.83,37.7,3019.05,3.97,0.0,27.39,
      34.73,0.0,3460; 3963,63.93,76.3,22.03,21.52,14.82,36.78,3004.8,3.97,0.0,
      26.56,33.92,0.0,3435; 3973,63.81,76.2,21.44,20.95,14.8,35.73,3051.62,
      3.97,0.0,25.83,33.16,0.0,3408; 3983,63.72,75.9,20.51,20.06,14.79,35.1,
      3035.15,3.97,0.0,25.14,32.45,0.0,3389; 3993,63.61,75.7,20.13,19.68,
      14.78,34.24,3016.0,3.97,0.0,24.53,31.78,0.0,3407; 4003,63.53,75.5,19.64,
      19.21,14.77,32.97,3015.0,3.97,0.0,23.93,31.19,0.0,3390; 4014,63.41,75.3,
      18.99,18.59,14.76,32.52,2997.29,3.97,0.0,23.42,30.55,0.0,3393; 4023,
      63.31,75.2,18.71,18.32,14.74,31.67,3050.16,3.97,0.0,22.92,29.92,0.0,
      3434; 4034,63.25,75.0,18.55,18.17,14.73,30.96,2954.26,3.97,0.0,22.47,
      29.3,0.0,3381; 4043,63.14,74.8,18.08,17.71,14.72,30.64,2987.56,3.97,0.0,
      22.06,28.8,0.0,3407; 4053,63.09,74.6,17.7,17.35,14.71,29.85,3014.58,
      3.97,0.0,21.69,28.43,0.0,3395; 4064,62.98,74.4,17.51,17.16,14.69,29.34,
      3049.4,3.96,0.0,21.33,27.95,0.0,3400; 4073,62.92,74.2,17.21,16.88,14.68,
      28.61,3008.6,3.76,0.0,21.01,27.64,0.0,3443; 4084,62.82,74.0,16.94,16.61,
      14.67,28.27,2971.28,3.81,0.0,20.72,27.23,0.0,3398; 4093,62.73,73.8,
      16.74,16.43,14.65,27.91,3022.22,3.78,0.0,20.45,26.84,0.0,3442; 4104,
      62.65,73.6,16.62,16.32,14.63,27.31,2973.55,3.77,0.0,20.21,26.53,0.0,
      3406; 4114,62.56,73.4,16.38,16.07,14.63,26.86,2977.77,3.85,0.0,19.94,
      26.19,0.0,3403; 4123,62.49,73.2,16.27,15.95,14.61,26.56,3048.61,3.82,
      0.0,19.71,25.8,0.0,3398; 4133,62.4,73.0,16.14,15.82,14.6,26.15,3020.08,
      3.83,0.0,19.51,25.45,0.0,3392; 4143,62.32,72.8,15.99,15.68,14.6,25.86,
      2967.43,3.67,0.0,19.3,25.22,0.0,3408; 4154,62.23,72.6,15.85,15.53,14.58,
      25.47,3022.42,3.78,0.0,19.11,24.94,0.0,3474; 4164,62.13,72.4,15.79,
      15.49,14.57,25.09,2988.21,3.55,0.0,18.92,24.62,0.0,3396; 4174,62.06,
      72.2,15.66,15.36,14.56,24.79,3030.46,3.04,0.0,18.77,24.34,0.0,3431;
      4184,62.0,72.1,15.56,15.27,14.55,24.58,3026.05,1.6,0.0,18.63,24.09,0.0,
      3391; 4193,61.9,71.9,15.48,15.21,14.55,24.35,2983.11,1.28,0.0,18.47,
      23.85,0.0,3388; 4204,61.82,71.7,15.37,15.09,14.54,23.96,2950.84,2.08,
      0.0,18.32,23.62,0.0,3395; 4214,61.73,71.5,15.32,15.04,14.54,23.68,
      2967.41,1.74,0.0,18.17,23.39,0.0,3391; 4224,61.63,71.4,15.22,14.96,
      14.54,23.59,2993.99,3.38,0.0,18.03,23.19,0.0,3439; 4233,61.57,71.1,
      15.19,14.94,14.54,23.3,2988.58,3.24,0.0,17.94,22.98,0.0,3388; 4244,
      61.49,71.0,15.13,14.84,14.54,23.07,2976.81,3.84,0.0,17.82,22.78,0.0,
      3447; 4253,61.4,70.8,15.07,14.81,14.53,22.83,2971.26,3.87,0.0,17.68,
      22.57,0.0,3399; 4264,61.35,70.6,15.06,14.8,14.53,22.56,2991.74,3.82,0.0,
      17.6,22.46,0.0,3439; 4274,61.24,70.4,14.96,14.7,14.52,22.36,2992.06,
      3.86,0.0,17.5,22.35,0.0,3394; 4284,61.17,70.3,14.93,14.67,14.51,22.19,
      2980.1,3.8,0.0,17.39,22.13,0.0,3387; 4294,61.08,70.1,14.91,14.65,14.51,
      22.04,2979.36,3.81,0.0,17.3,21.95,0.0,3391; 4303,61.02,69.9,14.86,14.62,
      14.51,21.84,2988.71,3.76,0.0,17.2,21.8,0.0,3392; 4314,60.92,69.7,14.8,
      14.56,14.5,21.65,3013.69,3.75,0.0,17.1,21.58,0.0,3388; 4324,60.84,69.5,
      14.79,14.55,14.49,21.53,2992.54,3.77,0.0,17.03,21.45,0.0,3386; 4334,
      60.76,69.4,14.77,14.51,14.48,21.4,2955.15,3.83,0.0,16.96,21.28,0.0,3422;
      4344,60.67,69.2,14.73,14.46,14.48,21.2,3016.78,3.82,0.0,16.87,21.14,0.0,
      3396; 4353,60.58,69.1,14.69,14.43,14.48,21.04,3019.26,3.84,0.0,16.79,
      20.97,0.0,3406; 4364,60.55,68.9,14.65,14.41,14.48,20.91,3022.59,3.81,
      0.0,16.72,20.82,0.0,3411; 4374,60.44,68.7,14.63,14.39,14.47,20.76,
      3010.2,3.78,0.0,16.66,20.69,0.0,3447; 4383,60.36,68.6,14.63,14.37,14.46,
      20.64,2956.02,3.83,0.0,16.58,20.6,0.0,3410; 4393,60.29,68.4,14.61,14.35,
      14.45,20.54,3018.06,3.78,0.0,16.51,20.44,0.0,3397; 4404,60.23,68.2,
      14.58,14.32,14.46,20.46,2974.58,3.67,0.0,16.44,20.37,0.0,3404; 4414,
      60.15,68.0,14.54,14.29,14.46,20.32,2947.11,3.85,0.0,16.39,20.23,0.0,
      3395; 4424,60.07,67.8,14.52,14.26,14.45,20.14,2945.09,3.79,0.0,16.33,
      20.11,0.0,3425; 4434,59.98,67.7,14.5,14.26,14.44,20.02,2983.33,3.88,0.0,
      16.27,20.03,0.0,3402; 4443,59.91,67.5,14.49,14.25,14.44,19.92,3031.1,
      3.81,0.0,16.22,19.95,0.0,3427; 4454,59.84,67.4,14.49,14.25,14.43,19.83,
      3023.94,3.85,0.0,16.18,19.84,0.0,3429; 4464,59.77,67.2,14.47,14.22,
      14.43,19.79,3017.25,3.78,0.0,16.11,19.73,0.0,3452; 4474,59.69,67.0,
      14.45,14.21,14.43,19.66,2983.79,3.77,0.0,16.06,19.64,0.0,3401; 4484,
      59.62,66.9,14.43,14.18,14.42,19.56,2985.3,3.8,0.0,16.02,19.52,0.0,3454;
      4493,59.55,66.7,14.39,14.16,14.42,19.49,2945.59,3.82,0.0,15.95,19.45,
      0.0,3419; 4504,59.48,66.5,14.39,14.14,14.41,19.4,3026.31,3.7,0.0,15.91,
      19.33,0.0,3393; 4513,59.41,66.4,14.38,14.13,14.4,19.32,2956.06,3.89,0.0,
      15.86,19.22,0.0,3405; 4524,59.32,66.2,14.36,14.13,14.39,19.21,3019.88,
      3.79,0.0,15.83,19.13,0.0,3425; 4534,59.25,66.0,14.35,14.12,14.39,19.11,
      3026.94,3.82,0.0,15.78,19.03,0.0,3382; 4544,59.18,65.9,14.35,14.11,
      14.39,19.04,2972.86,3.83,0.0,15.73,18.95,0.0,3404; 4554,59.13,65.7,
      14.35,14.1,14.39,18.97,3009.02,3.77,0.0,15.69,18.88,0.0,3438];
  // Measured data for step response with a volume flow of 3000 m^3/h in the air canal;

  annotation (
    Icon(coordinateSystem(preserveAspectRatio=false)),
    Diagram(coordinateSystem(preserveAspectRatio=false)),
    Documentation(info="<html><h4>
  Data of a step response experiment with the air handling unit 2
  (AHU2) Preheater
</h4>
<p>
  This record contains the measured data of a step response. The
  investigated system is a preheater of an air handling unit (air
  handling unit 2 of the E.ON ERC test hall. Data:
  ZUGABE_20171121_120612_measurement,
  ZUGABE_20171121_185531_measurement and
  ZUGABE_20171122_115805_measurement).
</p>
<p>
  The heating register is supplied by a mixing circuit with a
  three-way-valve.
</p>
<p>
  During the experiment the three-way-valve is fully openend until a
  steady-state is reached and closed afterwards.
</p>
<p>
  The experiment is performed for three different volume flow rates in
  the air canal of the air handling unit: 1000m^3/h, 2000m^3/h,
  3000m^3/h
</p>
<p>
  The record contains the following data points (columns):
</p>
<p>
  [1: Timestep | 2: 'AHU2.Ph.SenTempReFE.T' | 3:
  'AHU2.Ph.SenTempFlFe.T' | 4: 'AHU2.Ph.SenTempFlHeBel.T' | 5:
  'AHU2.Ph.SenTempReHeBel.T' | 6: 'AHU2.Ph.SenPTHEn.T' | 7:
  'AHU2.Ph.SenPTHEx.T' | 8: 'AHU2.Ac.SenVFSupA.VFout' | 9:
  'AHU2.Ph.SenBelVFWa.VF' | 10: 'AHU2.Ph.SenMFM.VF' | 11:
  'AHU2.Ph.TempF.T33' | 12: 'AHU2.Ph.TempF.T12' | 13:
  'AHU2.Ph.Valve3W.ValvePosAct | 14: 'AHU2.Ph.PumpComp.RevcAct']
</p>
</html>"));
end AHU2_Preheater_StepResponse;
